
## autogenerated ##


#' Start dextergui
#'
#' Opens a shiny application providing a graphical user interface to dexter. 
#' 
#' `dextergui()`
#' 
#' @param dbpath path to a dexter project database
#' or NULL, in which case you can select a project after starting dextergui
#' @param wd where dextergui looks for and saves files, defaults to current working directory. 
#' Within the gui you can move to subdirectories of \code{wd} but not further up the tree than \code{wd}.
#' 
#' 
#'
dextergui = function(dbpath = NULL, wd = getwd())
{
  roots = c('.' = normalizePath(wd))

  # nicer plots
  options(shiny.usecairo = TRUE)
  
  # 100mb upload limit
  options(shiny.maxRequestSize = 100*1024^2)
  
  server = function(input, output, session)
  {
    
    # some server globals
    db = NULL
    
    if(!is.null(dbpath)) 
      db = open_project(dbpath)
    
    # defaults are always reset in init_project
    default_reactive = list(rules = NULL, new_rules = NULL, ctt_items=NULL, ctt_booklets=NULL,
                            inter_booklet = NULL, inter_plot_items = NULL, item_properties=NULL,
                            import_data=NULL, parms=NULL, person_abl = NULL, selected_ctt_item = NULL,
                            person_properties=NULL, new_person_properties = NULL, abl_tables=NULL,
                            abl_varinfo=NULL, oplm_preview=NULL, 
                            ctt_items_settings = list(keep_search = FALSE), 
                            update_person_properties=TRUE, update_item_properties=TRUE)
    
    # these are kept between re-init, switch to databases etc.
    start_reactive = list(coef_format = 'norm', stack_facet='stacked', abp_stack_facet = 'stacked' )
    
    values = do.call(reactiveValues, modifyList(default_reactive, start_reactive, keep.null=TRUE))

    interaction_models = delayed_list$new()


# correct for bug in shinyFiles windows unc combination
    

if(tolower(Sys.info()['sysname']) == "windows" && substr(roots[1],1,2) %in% c('\\\\','//'))
{
  # copy paste of some functions in the shinyFiles package with small corrections 
  # to make it less demanding a windows dynamic link environment 
  
  shinyFileChoose <- function(input, id, updateFreq=2000, session = getSession(), 
                              defaultRoot=NULL, defaultPath='', ...) {
    fileGet <- do.call('fileGetter', list(...))
    currentDir <- list()
    clientId = session$ns(id)
    
    return(observe({
      dir <- input[[paste0(id, '-modal')]]
      if(is.null(dir) || is.na(dir)) {
        dir <- list(dir=defaultPath, root=defaultRoot)
      } else {
        dir <- list(dir=dir$path, root=dir$root)
      }
      dir$dir <- do.call(file.path, as.list(dir$dir))
      newDir <- do.call('fileGet', dir)
      if(!identical(currentDir, newDir)) {
        currentDir <<- newDir
        session$sendCustomMessage('shinyFiles', list(id=clientId, dir=newDir))
      }
      invalidateLater(updateFreq, session)
    }))
  }
  
  getSession <- function() {
    session <- shiny::getDefaultReactiveDomain()
    
    if (is.null(session)) {
      stop(paste(
        "could not find the Shiny session object. This usually happens when a",
        "shinyjs function is called from a context that wasn't set up by a Shiny session."
      ))
    }
    
    session
  }
  
  
  
  fileGetter <- function(roots, restrictions, filetypes, hidden=FALSE) {
    if (missing(filetypes)) filetypes <- NULL
    if (missing(restrictions)) restrictions <- NULL
    
    function(dir, root) {
      currentRoots <- if(class(roots) == 'function') roots() else roots
      
      if (is.null(names(currentRoots))) stop('Roots must be a named vector or a function returning one')
      if (is.null(root)) root <- names(currentRoots)[1]
      
      fulldir <- file.path(currentRoots[root], dir)
      writable <- as.logical(file.access(fulldir, 2) == 0)
      files <- list.files(fulldir, all.files=hidden, full.names=TRUE, no..=TRUE)
      files <- gsub(pattern='//*', '/', files, perl=TRUE)
      # moved to here to ameliorate slow file.info function on r 3.4 windows 10 slow file.info function
      if (!is.null(filetypes)) {
        ptrn = paste0(paste0('(\\.',filetypes,')', collapse = '|'), '$')
        # list.dirs is still slow but don't know how to recognize a dir otherwise
        files = files[grepl(ptrn, files, perl=TRUE) | dir.exists(files)]
      }
      if (!is.null(restrictions) && length(files) != 0) {
        if (length(files) == 1) {
          keep <- !any(sapply(restrictions, function(x) {grepl(x, files, fixed=T)}))
        } else {
          keep <- !apply(sapply(restrictions, function(x) {grepl(x, files, fixed=T)}), 1, any)
        }
        files <- files[keep]
      }
      fileInfo <- file.info(files)
      fileInfo$filename <- basename(files)
      fileInfo$extension <- tolower(file_ext(files))
      fileInfo$mtime <- format(fileInfo$mtime, format='%Y-%m-%d-%H-%M')
      fileInfo$ctime <- format(fileInfo$ctime, format='%Y-%m-%d-%H-%M')
      fileInfo$atime <- format(fileInfo$atime, format='%Y-%m-%d-%H-%M')
      if (!is.null(filetypes)) {
        matchedFiles <- tolower(fileInfo$extension) %in% tolower(filetypes) & fileInfo$extension != ''
        fileInfo$isdir[matchedFiles] <- FALSE
        fileInfo <- fileInfo[matchedFiles | fileInfo$isdir,]
      }
      rownames(fileInfo) <- NULL
      breadcrumps <- strsplit(dir, .Platform$file.sep)[[1]]
      
      list(
        files=fileInfo[, c('filename', 'extension', 'isdir', 'size', 'mtime', 'ctime', 'atime')],
        writable=writable,
        exist=file.exists(fulldir),
        breadcrumps=I(c('', breadcrumps[breadcrumps != ''])),
        roots=I(names(currentRoots)),
        root=root
      )
    }
  }
  
  shinyFileSave <- function(input, id, updateFreq=2000, session=getSession(),
                            defaultPath='', defaultRoot=NULL, ...) {
    fileGet <- do.call('fileGetter', list(...))
    dirCreate <- do.call('dirCreator', list(...))
    currentDir <- list()
    lastDirCreate <- NULL
    clientId = session$ns(id)
    
    return(observe({
      dir <- input[[paste0(id, '-modal')]]
      createDir <- input[[paste0(id, '-newDir')]]
      if(!identical(createDir, lastDirCreate)) {
        dirCreate(createDir$name, createDir$path, createDir$root)
        dir$path <- c(dir$path, createDir$name)
        lastDirCreate <<- createDir
      }
      if(is.null(dir) || is.na(dir)) {
        dir <- list(dir=defaultPath, root=defaultRoot)
      } else {
        dir <- list(dir=dir$path, root=dir$root)
      }
      dir$dir <- do.call(file.path, as.list(dir$dir))
      newDir <- do.call('fileGet', dir)
      if(!identical(currentDir, newDir) && newDir$exist) {
        currentDir <<- newDir
        session$sendCustomMessage('shinySave', list(id=clientId, dir=newDir))
      }
      invalidateLater(updateFreq, session)
    }))
  }
  
  dirCreator <- function(roots, ...) {
    function(name, path, root) {
      currentRoots <- if(class(roots) == 'function') roots() else roots
      
      if (is.null(names(currentRoots))) stop('Roots must be a named vector or a function returning one')
      
      location <- do.call('file.path', as.list(path))
      location <- file.path(currentRoots[root], location, name)
      
      dir.create(location)
    }
  }
  
  shinyFileChoose(input, 'open_proj_fn', roots = roots, filetypes=c('db','sqlite'), updateFreq=15000)
  shinyFileSave(input, 'new_proj_fn', roots = roots, filetypes=c('db','sqlite'), session=session, restrictions=system.file(package='base'), updateFreq=15000)
  shinyFileSave(input, 'start_new_project_from_oplm_dbname', filetypes=c('db','sqlite'), roots = roots, session=session, restrictions=system.file(package='base'), updateFreq=15000)
  
} else
{
  shinyFileChoose(input, 'open_proj_fn', roots = roots, filetypes=c('db','sqlite'))
  shinyFileSave(input, 'new_proj_fn', roots = roots, filetypes=c('db','sqlite'), session=session, restrictions=system.file(package='base'))
  shinyFileSave(input, 'start_new_project_from_oplm_dbname', filetypes=c('db','sqlite'), roots = roots, session=session, restrictions=system.file(package='base'))
}

observeEvent(input$start_new_project_from_oplm_dbname,
{
  updateTextInput(session, 'start_new_project_from_oplm_dbname_display',
                  value = parseSavePath(roots, input$start_new_project_from_oplm_dbname)[1,1])
})
    
    
    
# RE-INIT, run init_project() at the start and  whenever a (significant) db change occurs ------------------------
    

init_project = function()
{
  show('project_load_icon')
  hide('prj_alter_rules')

  output$project_pth = renderText(gsub('\\.\\w+$','',basename(db@dbname), perl=TRUE))
  
  booklets = dbGetQuery(db, 'SELECT booklet_id FROM dxBooklets ORDER BY booklet_id;')$booklet_id
  
  updateSelectInput(session, 'add_booklet_name', choices = c('type or choose booklet_id' = '', booklets))
  output$data_import_result = renderUI({})
  
  covariates = setdiff(dbListFields(db, 'dxpersons'),'person_id')
  updateSelectInput(session,'prs_abl_plot_variable', choices = covariates)
  updateSelectInput(session,'prs_abl_plot_fill', choices = covariates)
  
  # reset reactiveValues
  lapply(names(default_reactive), function(nm){values[[nm]] = default_reactive[[nm]]})
  
  values$rules = get_rules(db)
  values$item_properties = get_items(db)
  values$person_properties = get_persons(db) %>% mutate_if(is.masked.integer, as.integer)
 
  interaction_models$clear()

  if(length(booklets) > 0)
  {
    data = dexter:::get_resp_data(db,summarised=FALSE)

    ## prepare interaction
    for(bkl in booklets)
    {
      env = new.env()
      env$bkl = eval(bkl)
      interaction_models$assign(bkl, fit_inter(resp_data_bkl(data, bkl)), env=env)
      #interaction_models$assign(bkl, fit_inter(db, booklet_id==bkl), env=env)
    }
    
    ## prepare CTT ##
    
    tia = tia_tables(data, type='raw')
    
    
    sparks = dexter:::get_resp_data(data, summarised=TRUE)$x %>% 
      group_by(booklet_id) %>%
      summarise(test_score = sparkbox_vals(.data$sumScore))#, 
                #test_score2 = sparkhist_vals(sumScore, nbar=12, .min = 0, .max = max(tia$testStats$maxTestScore)) )
    
    values$ctt_items = tia$itemStats
    
    values$ctt_booklets = tia$testStats %>%
      mutate(alpha = round(.data$alpha,3), meanP = round(.data$meanP,3), meanRit = round(.data$meanRit,3), meanRir = round(.data$meanRir,3)) %>%
      inner_join(sparks, by='booklet_id')
    
    if(all(grepl('^\\d+$',values$ctt_booklets$booklet_id)))
    {
      values$ctt_booklets = values$ctt_booklets %>%
        mutate(booklet_id = as.integer(.data$booklet_id)) %>%
        arrange(.data$booklet_id)
      
      values$ctt_items =  values$ctt_items %>%
        mutate(booklet_id = as.integer(.data$booklet_id)) %>%
        arrange(.data$item_id, .data$booklet_id)
    }
    
  }
  
  session$sendCustomMessage(type = 'set_js_vars', 
                            message=list(data = list(variables = get_variables(db))))
  
  hide('project_load_icon')
  hide('oplm_inputs')
  hide('abl_tables_plot_booklet')
  runjs(enable_panes(c('rules_pane', 'ctt_pane', 'inter_pane','data_pane', 'enorm_pane')))
  shinyjs::enable(selector='#go_import_new_rules,#go_import_new_itemprop,#go_import_new_personprop')
  updateImgSelect(session, inputId = "abp_plotbar",choices=list())
}


## init for the first time if a db is specified, otherwise disable all other panes
if(is.null(db))
{
  hide('project_load_icon')
  runjs(disable_panes(c('rules_pane', 'ctt_pane', 'inter_pane','data_pane', 'enorm_pane')))
  shinyjs::disable(selector='#go_import_new_rules,#go_import_new_itemprop,#go_import_new_personprop')
  output$project_pth = renderText('No project loaded yet')
} else
{
  init_project()
}

hide('oplm_inputs')
    values$ctt_items_settings = list(keep_search = TRUE)
      
# autofill for predicate
observeEvent(input$varsuggest, 
{
  req(db)
  session$sendCustomMessage(type = 'predicate_suggestion', 
      message = list(variable = input$varsuggest$variable, 
                     start = input$varsuggest$start,
                     suggestions = dxvar_suggestion(db, input$varsuggest$variable, input$varsuggest$start)))
})
    
# clean up
session$onSessionEnded(function(x){ if(!is.null(db)) close_project(db) })


# project page ------------------------------------------------------------



# OPEN OR START PROJECT ---------------------------------------------------


observeEvent(input$open_proj_fn,
{
  open_proj_fn = parseFilePaths(roots, input$open_proj_fn)
  if(!is.null(db))
    close_project(db)
  db <<- open_project(as.character(open_proj_fn$datapath))
  values$ctt_items_settings$keep_search = FALSE
  init_project()
  values$ctt_items_settings$keep_search = TRUE
})

observeEvent(input$new_proj_fn,
{
  new_proj_fn = parseSavePath(roots, input$new_proj_fn)
  if(!is.null(db))
    close_project(db)             
  # start a truly empty project in a way not advertised anywhere
  db <<- start_new_project(as.character(new_proj_fn$datapath),
                                        rules = tibble(item_id='a',response='b',item_score=0) %>% filter(0==1))
  values$ctt_items_settings$keep_search = FALSE
  init_project()
  values$ctt_items_settings$keep_search = TRUE
  updateTabsetPanel(session, 'proj_rules_tabs', selected = 'Add rules from a file')
  
})

observeEvent(input$start_new_project_from_oplm_dat_path,
{
  data_file = input$start_new_project_from_oplm_dat_path
  if(is.null(data_file))
  {
    #values$oplm_dat_path = NULL
    values$oplm_preview = NULL
  } else
  {
    #fn = tempfile('oplm', fileext='.dat')
    #file.copy(data_file$datapath, fn)
    
    con = file(data_file$datapath, "r", blocking = FALSE) 
    pv = readLines(con, 10)
    close(con)
    #values$oplm_dat_path = fn
    values$oplm_preview = pv
  }
}) 


# oplm inlezen
output$oplm_dat = renderTable(
{
  if(!is.null(values$oplm_preview))
  {
    bkl = input$start_new_project_from_oplm_booklet_position
    prs = input$start_new_project_from_oplm_person_id
    rsp = input$start_new_project_from_oplm_responses_start
    
    pos = list()
    if(!is.na(rsp)) pos$rsp = tibble(name = 'responses', begin=rsp, end=as.integer(NA))
    if(!is.null(bkl))
    {
      if(is.na(bkl[2]) || bkl[2] < bkl[1]) bkl[2] = bkl[1]
      if(is.na(rsp) || !(rsp <= bkl[2] ))
        pos$bkl = tibble(name = 'booklet', begin=bkl[1], end=bkl[2])
    }
    if(!is.null(prs))
    {
      if(is.na(prs[2]) || prs[2] < prs[1]) prs[2] = prs[1]
      if((is.null(rsp) || !(rsp <= prs[2])) && (is.null(bkl) || length(intersect(prs[1]:prs[2],bkl[1]:bkl[2])) == 0))
        pos$prs = tibble(name = 'person_id', begin=prs[1], end=prs[2])
    }
    if(length(pos) == 0)
    {
      out = data.frame(skip1 = values$oplm_preview)
    } else
    {
      pos = pos %>% bind_rows() %>% arrange(.data$begin)  %>% as.data.frame()
      n=nrow(pos)
      l = 0

      for(i in 1:n)
      {
        if(l < (pos[i,c('begin')] - 1))
        {
          pos = add_row(pos, name=paste0('skip',i),begin = l+1, end = pos[i,'begin'] -1)
        }
        l = pos[i,'end']
      }
      if(!is.na(l)) pos = add_row(pos, begin = max(pos$end)+1, name='skip.end')

      pos = arrange(pos, .data$begin) %>% mutate_if(is.numeric, as.integer)
        
      out = list()
      
      for(i in 1:nrow(pos))
      {
        out[[pull(pos, .data$name)[i]]] = substring(values$oplm_preview, pull(pos, .data$begin)[i], coalesce(pull(pos, .data$end)[i], 10000L))
      }
      out = as.data.frame(out)
    }
 
    colnames(out) = gsub('^skip.+$','',colnames(out))
    out
  }
}, bordered=FALSE, spacing='xs', caption='.dat file preview',caption.placement='top')



observeEvent(input$go_start_new_project_from_oplm,
{
  new_proj_fn = parseSavePath(roots, input$start_new_project_from_oplm_dbname)
  data_file = input$start_new_project_from_oplm_dat_path
  scr_file = input$start_new_project_from_oplm_scr_path

  withBusyIndicatorServer("go_start_new_project_from_oplm",{
    
    if(nrow(new_proj_fn) == 0)  stop('dbname is required')
    if(is.null(data_file))      stop('No .dat file selected')
    if(is.null(scr_file))       stop('No .scr file selected')
    
    if(is.null(input$start_new_project_from_oplm_booklet_position)) 
      stop('booklet_position is required')
    
    if(input$start_new_project_from_oplm_booklet_position[1] >= input$start_new_project_from_oplm_responses_start)
      stop('responses overlap with booklet_id')

    if(!is.null(db))
      close_project(db)
    
    db <<- start_new_project_from_oplm(
      dbname = as.character(new_proj_fn$datapath),
      dat_path = as.character(data_file$datapath),
      scr_path = as.character(scr_file$datapath),
      booklet_position = input$start_new_project_from_oplm_booklet_position,
      responses_start = input$start_new_project_from_oplm_responses_start,
      person_id = input$start_new_project_from_oplm_person_id,
      use_discrim = input$start_new_project_from_oplm_use_discrim,
      response_length = input$start_new_project_from_oplm_response_length)
    
    values$ctt_items_settings$keep_search = FALSE
    init_project()
    values$ctt_items_settings$keep_search = TRUE
  })

})


# VIEW / ADD / AMEND RULES ------------------------------------------------

observeEvent(input$rules_file,{
  
  input_file = input$rules_file
  rules = read_excel(input_file$datapath, sheet=1)
  colnames(rules) = tolower(colnames(rules))
  if(length(setdiff(c('item_id','item_score','response'),colnames(rules))) == 0)
  {
    values$new_rules = rules %>%
      mutate(item_score = as.integer(.data$item_score), item_id = as.character(.data$item_id), 
             response = gsub('\\.0+$','',as.character(.data$response), perl=TRUE)) %>%
      select(.data$item_id, .data$response, .data$item_score)
    output$rules_upload_error = renderText({''})
  } else if(length(setdiff(c('item_id','noptions','key'),colnames(rules))) == 0)
  {
    values$new_rules = keys_to_rules(rules %>% mutate(nOptions = as.integer(.data$noptions)))
    output$rules_upload_error = renderText({''})
  } else
  {
    #foutje, TO DO: error message
    output$output$rules_upload_error = renderText(
      {
        paste0('The input file has to contain columns (item_id, item_score, response) ',
               'or (item_id, nOptions, key)')
      })
    values$new_rules = NULL
  }

})

output$new_rules_preview = renderTable({
  if(!is.null(values$new_rules))
  {
    tibble(column = c('item_id','response','item_score'), 
           values = paste0(sapply(values$new_rules[1:10, c('item_id','response','item_score')], paste, collapse = ', '),', ...'))
  }
}, caption = 'file preview')

observeEvent(input$go_import_new_rules,{
  if(!is.null(values$new_rules))
  {
    withBusyIndicatorServer("go_import_new_rules",
    {
      touch_rules(db, values$new_rules)
      values$new_rules = NULL
      values$rules = get_rules(db)
      values$item_properties = get_items(db)
    })
  }
})


output$rules = renderDataTable(
{
  req(values$rules)
  values$rules %>% 
      add_column(old_item_score = values$rules$item_score) 
}, 
 selection = 'none', rownames = FALSE, colnames = c('item_id','response','item_score',''), 
 class='compact readable', server=FALSE, escape=FALSE,
 options = list(pageLength = 20, autoWidth = FALSE,
                columnDefs = list(list(targets = 3, 
                                       render = JS("function(data,type,row){return(row[2] == row[3] ? '' : '<span class=\"label label-info\">!</span>')}"))))
)

observeEvent(input$rules_data, {
  show('prj_alter_rules')
})

observeEvent(input$prj_alter_rules, {
  new_rules = as_tibble(lapply(input$rules_data, unlist))
  colnames(new_rules)[ncol(new_rules)] = 'old_val'
  new_rules = filter(new_rules, .data$item_score != .data$old_val)
  if(nrow(new_rules) > 0)
  {
    withBusyIndicatorServer('prj_alter_rules',
    {
      # dexter error message if wrong not extremely intelligble yet without output
      touch_rules(db, new_rules)
      init_project()
      hide('prj_alter_rules')
    })
  } else
  {
    hide('prj_alter_rules')
  }
})



# ITEM PROPERTIES ---------------------------------------------------------

output$item_properties = renderDataTable(
  {
    req(values$item_properties)
    # skip once if necessary
    # this has a side effect (toggle) !
    isolate({
      update = values$update_item_properties
      values$update_item_properties = TRUE})
    
    req(update, cancelOutput = TRUE)

    datatable(values$item_properties, 
              selection = 'none', rownames = FALSE,  
              class='compact readable', 
              options = list(pageLength = 20, autoWidth = FALSE,
                             scrollX = TRUE,
                             fixedColumns = list(leftColumns = 1),
                             orderCellsTop = TRUE),
                             extensions = 'FixedColumns')
    
  })   

# react to user update without redrawing the table
ip_proxy = dataTableProxy('item_properties')

observeEvent(input$item_properties_user_update,
{

  indx = input$item_properties_user_update$col_index
  upd = tibble(item_id = input$item_properties_user_update$row[[1]])
  upd[[colnames(values$item_properties)[indx]]] = input$item_properties_user_update$row[[indx]]
  add_item_properties(db, upd)
  values$item_properties = get_items(db)
  values$update_item_properties = FALSE
  replaceData(ip_proxy, values$item_properties, rownames = FALSE, resetPaging = FALSE)
})
                                      

# read from file
observeEvent(input$itemprop_file,{
  input_file = input$itemprop_file
  values$new_item_properties = read_excel(input_file$datapath, sheet=1)
  
})

output$new_itemprop_preview = renderTable({
  if(!is.null(values$new_item_properties))
  {
    tibble(column = colnames(values$new_item_properties), 
           values = paste0(sapply(slice(values$new_item_properties, 1:10), paste, collapse = ', '),', ...'))
  }
})

observeEvent(input$go_import_new_itemprop,
{
  withBusyIndicatorServer("go_import_new_itemprop",
  {
    if(!('item_id' %in% tolower(colnames(values$new_item_properties))))
      stop('missing item_id column')

    add_item_properties(db, values$new_item_properties )
    values$new_item_properties = NULL
    session$sendCustomMessage(type = 'set_js_vars', 
                              message=list(data = list(variables = get_variables(db))))
  })
})




# PERSON PROPERTIES -------------------------------------------------------

output$person_properties = renderDataTable(
{
  req(values$person_properties)
  # skip once if necessary
  isolate({
    update = values$update_person_properties 
    values$update_person_properties = TRUE})
  
  req(update, cancelOutput = TRUE)

  datatable(values$person_properties, 
            selection = 'none', rownames = FALSE,  
            class='compact readable', 
            options = list(pageLength = 20, autoWidth = FALSE,
                            scrollX = TRUE,
                            fixedColumns = list(leftColumns = 1),
                            orderCellsTop = TRUE),
            extensions = 'FixedColumns')

})   

# react to user update without redrawing the table
pp_proxy = dataTableProxy('person_properties')

observeEvent(input$person_properties_user_update,
{
  indx = input$person_properties_user_update$col_index
  upd = tibble(person_id = input$person_properties_user_update$row[[1]])
  upd[[colnames(values$person_properties)[indx]]] = input$person_properties_user_update$row[[indx]]
  add_person_properties(db, upd)
  values$person_properties = get_persons(db)
  values$update_person_properties = FALSE
  replaceData(pp_proxy, values$person_properties, rownames = FALSE, resetPaging = FALSE)
})


observeEvent(input$person_property_file,
{
  values$new_person_properties = read_excel(input$person_property_file$datapath, sheet=1)
})


output$new_personprop_preview = renderTable({
  if(!is.null(values$new_person_properties))
  {
    tibble(column = colnames(values$new_person_properties), 
           values = paste0(sapply(slice(values$new_person_properties, 1:10), paste, collapse = ', '),', ...'))
  }
})

observeEvent(input$go_import_new_personprop,
{
  if(!is.null(values$new_person_properties))
  {
    withBusyIndicatorServer("go_import_new_personprop",
    {
      if(!('person_id' %in% tolower(colnames(values$new_person_properties))))
        stop('missing person_id column')
      
      add_person_properties(db, values$new_person_properties)
      values$new_person_properties = NULL
      session$sendCustomMessage(type = 'set_js_vars', 
                                message=list(data = list(variables = get_variables(db))))
    })
  }
})



    
# Respons data import -------------------------------------------------------



observe({
  data_file = input$data_file
  if(is.null(data_file))
  {
    values$import_data = NULL
  } else
  {
    values$import_data = read_excel(data_file$datapath, sheet=1)
  }
})

output$data_preview = renderTable({
  req(values$import_data)

  preview = dbGetQuery(db,'SELECT item_id AS column FROM dxItems;') %>% 
      add_column(type = 'item', change = '') %>%
      right_join(tibble(column = colnames(values$import_data), 
                        values = sapply(slice(values$import_data,1:10),paste, collapse=', ')), by='column')
    
  preview[grepl('person_id', preview$column, ignore.case=TRUE),'type'] = 'person identifier'
  preview[is.na(preview$type) & tolower(preview$column) %in% dbListFields(db, 'dxpersons'), 'type'] = 'covariate'
    
  btn = paste0('<button type="button" onclick="',"
        me = $(this); 
        Shiny.onInputChange('add_covariate',me.closest('tr').find('td:first-child').text());
        me.closest('tr').find('td:nth-child(2)').text('covariate');
        me.remove();",
      '">add as person property</button>')

  preview[is.na(preview$type),'change'] = btn
  preview[is.na(preview$type),'type'] = 'ignored'
    
  preview$values = paste0(substring(preview$values,1,100),', ...')
    
  preview = mutate(preview, column = htmlEscape(column), values = htmlEscape(values))
  colnames(preview) = c('column','import as','','values')
  
  preview
}, sanitize.text.function = identity, caption='Response data preview')


observeEvent(input$add_covariate, {
  if(!is.null(values$import_data))
  {
    var = trimws(input$add_covariate)
    col = pull(values$import_data, var)
    dflt = list()
    if(typeof(col) == 'integer' || (typeof(col) == 'character' && all(grepl('^\\d+(\\.0)?$', col, perl = TRUE)))) 
    {
      dflt[var] = as.integer(NA)
    } else if(is.numeric(col) || (typeof(col) == 'character' && all(grepl('^\\d+(\\.\\d+)?$', col, perl = TRUE)))) 
    {
      dflt[var] = as.double(NA)
    } else
    {
      dflt[var] = ""
    }
    # person properties empty tibble is against bug in dexter 0.7.0, can be removed if switch to 0.7.1 or later
    dummy = data.frame(person_id=1)
    dummy[[var]] = ''
    add_person_properties(db, person_properties = slice(dummy,0), default_values = dflt) 
    session$sendCustomMessage(type = 'set_js_vars', 
                              message=list(data = list(variables = get_variables(db))))
  }
})


observeEvent(input$go_import_data, {
  withBusyIndicatorServer("go_import_data",
  {
    booklet_id = trimws(input$add_booklet_name)
    
    if(is.null(values$import_data))
      stop('no response data to import')
    
    if(booklet_id == '')
      stop('please provide a booklet_id')
    

    result = add_booklet(db, values$import_data, booklet_id = booklet_id)
    n = nrow(values$import_data)
    values$import_data = NULL
    shinyjs::reset('data_file')
    
    init_project()
    
    msg = list(
      hr(),
      tags$p(tags$i('Most recently imported:')),
      tags$p(
        tags$b('Booklet: '),
        tags$span(booklet_id)),
      tags$p(
        tags$b('Responses: '),
        tags$span(n)),
      tags$p(
        tags$b('Items: '),
        tags$span(paste(result$items, collapse=', '))))
    
    if('person_properties' %in% names(result) && length(result$person_properties > 0 ) )
      msg = append(msg, 
                   list(tags$p(tags$b('Person properties: '),
                               tags$span(paste(result$person_properties, collapse=', ')))))
    
    if('columns_ignored' %in% names(result) && length(result$columns_ignored > 0 ))
      msg = append(msg, 
                   list(tags$p(tags$b('Columns ignored: '),
                               tags$span(paste(result$columns_ignored, collapse=', ')))))
    
    
    output$data_import_result = renderUI(tagList(msg))
    
  })
})

# Classical test theory ---------------------------------------------------


# Booklets (Interaction model) ----------------------------------------------    

output$inter_booklets = renderDataTable({
  req(values$ctt_booklets)
  cdef = list(list(targets = ncol(values$ctt_booklets)-1, 
                   render = JS("function(data, type, full){ return '<span class=\"sparkbox\">' + data + '</span>' }")),
              list(className = "numeric", targets = list(7)),
              list(className = "dec-3", targets = list(2,3,4,5)))
  
  drawcallback = init_sparks(.box = list(chartRangeMin = 0, chartRangeMax = max(values$ctt_booklets$maxTestScore)),
                             add_js='dt_numcol(settings);')
  
  selected = 1
  isolate({
    if(!is.null(values$inter_booklet))
    {
      selected = min(which(values$ctt_booklets == values$inter_booklet))
    }
  })
  
  datatable(
    {
        values$ctt_booklets 
    }, rownames = FALSE, selection = list(mode = 'single', selected = selected), 
            class='compact', extensions = 'Buttons',
            options = list(columnDefs = cdef, fnDrawCallback = drawcallback,
                           buttons = dt_buttons('inter_booklets'),
                           searching = FALSE, pageLength = 15, scrollX = TRUE, autoWidth=FALSE, dom='<"dropdown" B>lrtip',
                           initComplete = JS("dt_btn_dropdown")))
  
})

output$inter_booklets_xl_download = downloadHandler(
    filename = function(){paste0(gsub('\\.\\w+$','',basename(db@dbname), perl=TRUE),'_ctt_booklets.xlsx')},
    content = function(file) {
      write_xlsx(values$ctt_booklets, file)
    }
)
output$inter_booklets_csv_download = downloadHandler(
  filename = function(){paste0(gsub('\\.\\w+$','',basename(db@dbname), perl=TRUE),'_ctt_booklets.csv')},
  content = function(file) {
    write.csv2(values$ctt_booklets, file, row.names = FALSE, fileEncoding = "utf8")
  }
)

observe({
  if(!is.null(input$inter_booklets_rows_selected) && !is.null(db))
  {
    values$inter_booklet = as.character(values$ctt_booklets$booklet_id[input$inter_booklets_rows_selected])
    values$inter_plot_items = dbGetQuery(db, 'SELECT item_id FROM dxBooklet_design WHERE booklet_id=:booklet ORDER BY item_position;',
                                         tibble(booklet=values$inter_booklet))$item_id
    
  }
}, priority=2)


output$inter_current_booklet = renderUI(tags$b(paste('Booklet:', values$inter_booklet)))

observe({
  req(values$inter_booklet, values$inter_plot_items)

  f = interaction_models$get(values$inter_booklet)
  updateSlider(session, 'interslider',
    lapply(values$inter_plot_items, function(item)
    {
        outfile = tempfile(fileext = '.png')
        png(outfile, width = 200, height = 140)
        op = par(mar=rep(0,4))
        plot(f, items = item, show.observed = input$inter_show_observed, curtains = input$inter_curtains, 
             summate = input$inter_summate, main=NULL,xlab=NA,ylab=NA,sub=NULL,xaxt='n',yaxt='n', ann=FALSE)
        dev.off()
        par(op)
        list(src = outfile, contentType = 'image/png', choice_id = item)
     })
  )
}, priority = 1)

output$interslider_plot = renderPlot({
  req(values$inter_booklet, values$inter_plot_items, input$interslider_select, 
      input$interslider_select %in% values$inter_plot_items) # not evaluate before new booklet has finished evaluating
  
  f = interaction_models$get(values$inter_booklet)
  plot(f, items = input$interslider_select, show.observed = input$inter_show_observed, 
       curtains = input$inter_curtains, summate = input$inter_summate,main='$item_id')
})







# items & distractor plots ---------------------------------------------------------

output$ctt_items = renderDataTable(
{
  req(values$ctt_items)
  data = ctt_items_table(values$ctt_items, input$ctt_items_averaged)
  selected = 1
  search_ = ""
  
  isolate({

    if(!is.null(values$selected_ctt_item))
      selected = min(which(data[['item_id']] == values$selected_ctt_item[['item_id']]))

    if(values$ctt_items_settings$keep_search && !is.null(input$ctt_items_search))
      search_ = input$ctt_items_search

  })  
    
  datatable(data, 
    rownames = FALSE, selection = list(mode = 'single', selected = selected), class='compact',
    extensions = 'Buttons',
    options = list(dom='<"dropdown" B>lfrtip',
                   buttons = dt_buttons('ctt_items'),
                   search = list(search = search_),
                   pageLength = 20, scrollX = TRUE,
                   columnDefs = list(list(className = "numeric", targets = list(8)),
                                     list(className = "dec-3", targets = list(5,6,7)),
                                     list(className = "dec-2", targets = list(2,3))),
                   fnDrawCallback = JS('dt_numcol'),
                   initComplete = JS(paste0(
                                      'function(dtsettings){
                                        dt_btn_dropdown(dtsettings);
                                        dt_show_row(dtsettings,',selected-1,');
                                      }'))))
})

output$ctt_items_xl_download = downloadHandler(
  filename = function(){paste0(gsub('\\.\\w+$','',basename(db@dbname), perl=TRUE),'_ctt_items.xlsx')},
  content = function(file) {
    write_xlsx(ctt_items_table(values$ctt_items, input$ctt_items_averaged), file)
  }
)
output$ctt_items_csv_download = downloadHandler(
  filename = function(){paste0(gsub('\\.\\w+$','',basename(db@dbname), perl=TRUE),'_ctt_items.csv')},
  content = function(file) {
    write.csv2(ctt_items_table(values$ctt_items, input$ctt_items_averaged), file, 
               row.names = FALSE, fileEncoding = "utf8")
  }
)



# infer from the ctt items table which item was selected
observe({
  if(is.null(input$ctt_items_rows_selected))
  { 
    values$selected_ctt_item = NULL
  } else
  {
    values$selected_ctt_item = ctt_items_table(values$ctt_items, input$ctt_items_averaged)[input$ctt_items_rows_selected,]
  }
}, priority=1) 

output$ctt_selected_item = renderUI({if(!is.null(values$selected_ctt_item)) values$selected_ctt_item$item_id})

output$ctt_plot = renderPlot({
  req(db, values$selected_ctt_item)

  ctt_item = values$selected_ctt_item
  if('booklet_id' %in% names(ctt_item))
  {
    booklet = pull(ctt_item, booklet_id)
    distractor_plot(db, {booklet_id==booklet}, item = pull(ctt_item, 'item_id'),main='position $item_position in $booklet_id',sub=NULL,legend=FALSE)
  } else
  {
    rc = matrix_layout(dbGetQuery(db,'SELECT COUNT(*) AS n FROM dxBooklet_design WHERE item_id=:item_id;',
                                    select(ctt_item, .data$item_id))$n)
    distractor_plot(db, item = pull(ctt_item, 'item_id'), nr = rc[1], nc = rc[2], main='position $item_position in $booklet_id',sub=NULL,legend=FALSE)
  }
})


output$item_rules = renderDataTable({
  req(db, values$selected_ctt_item)

  ctt_item = values$selected_ctt_item

  df = dbGetQuery(db, paste0(
        'WITH cnts AS (
          SELECT item_id, response, COUNT(*) AS n 
            FROM dxResponses
            WHERE item_id=:item_id',
              ifelse('booklet_id' %in% colnames(ctt_item),' AND booklet_id=:booklet_id ',' '),
        'GROUP BY item_id, response)
        SELECT item_id, response, COALESCE(n,0) AS n, item_score, item_score AS old_item_score
          FROM dxScoring_rules 
            INNER JOIN cnts USING(item_id, response)
          WHERE dxScoring_rules.item_id=:item_id
          ORDER BY n DESC, response;'),
        suppressWarnings(select(values$selected_ctt_item, one_of('item_id', 'booklet_id'))))
      
    df = add_column(df, legend = dexter:::qcolors(nrow(df)), .after = 1)
      
    sketch = tags$table(
        class = "compact readable",
        tableHeader(c('item_id','','response','n','score','')),
        tags$tfoot(tags$tr(tags$td(),
                           tags$td(),
                           tags$td('sum: ', style='text-align: right;'), 
                           tags$td(tags$div(sum(df$n), style="background-color:lightgrey;width:100%;height:100%;text-align:center;")),
                           tags$td(paste('avg: ',ctt_item$meanScore), style='text-align: right;'),
                           tags$td()),
                   style="font-style:italic;"))
      
    df$n = paste(df$n, sum(df$n),sep=',')
      
    runjs("$('#go_save_ctt_item_rules').removeClass('btn-primary');")
      
    datatable(df, container = sketch, selection = 'none',  rownames = FALSE, class = "compact readable",
                options = list(autoWidth = FALSE,
                               paging = FALSE,
                               scrollY = '300px',
                               scrollCollapse = TRUE,
                               dom = 't',
                               initComplete = JS("function(settings){dtshrink(settings)}"),
                               fnDrawCallback = init_sparks(),
                               columnDefs = list(list(targets = 5, 
                                                      render = JS("function(data,type,row){
                                                                  return(row[4] == row[5] ? '' : '<span class=\"label label-info\">!</span>')}")),
                                                 list(targets = 3,
                                                      render = JS("function(data, type, full){ return '<span class=\"sparkcount\">' + data + '</span>' }")),
                                                 list(targets = 1,
                                                      render = JS("function(data, type, full){ return '<span class=\"sparklegend\">' + data + '</span>' }"),
                                                      orderable = FALSE),
                                                 list(targets = 0,
                                                      visible = FALSE))))

}, server = FALSE)

observeEvent(input$item_rules_data, {
  runjs("$('#go_save_ctt_item_rules').addClass('btn-primary');")
})

observeEvent(input$go_save_ctt_item_rules, {
  req(input$item_rules_data)
  new_rules = as_tibble(lapply(input$item_rules_data, unlist)) %>%
      select(.data$item_id, .data$response, item_score = 'score', old_val = 'V6')
  
  withBusyIndicatorServer("go_save_ctt_item_rules",
  {
    
    if(any(new_rules$item_score %% 1 != 0))
    {
      stop('only integer scores allowed')
    } else if(min(new_rules$item_score) < 0 )
    {
      stop('negative scores not allowed')
    } else if(min(new_rules$item_score) > 0 )
    {
        stop('Item should have at least one option scored 0')
    } else if(max(new_rules$item_score) < 1)
    {
      stop('Item should have at least one option with a score > 0')
    } else
    {
      if(nrow(filter(new_rules, .data$item_score != .data$old_val)) >  0)
      {
        touch_rules(db, new_rules)
        values$ctt_items_settings$preselected = isolate(input$ctt_items_rows_selected)
        values$ctt_booklets_settings$preselected = isolate(input$inter_booklets_rows_selected)
        init_project()
      }
      runjs("$('#go_save_ctt_item_rules').removeClass('btn-primary');")
    }
  })
})

# ENORM -------------------------------------------------------------------

# graph title is side effect of this

output$design_plot = renderForceNetwork({
  req(db)
  values$ctt_items #so shiny knows to reinit this on new project
  if(trimws(input$enorm_predicate == ''))
  {
    design = get_design(db, format='long') %>%
      inner_join(get_booklets(db), by='booklet_id') %>%
      filter(.data$n_persons > 0) %>%
      select(.data$booklet_id, .data$item_id)
  } else
  {
    design = try(eval(parse(text=paste0("dexter:::get_resp_data(db, ",
                                        "qtpredicate= eval(substitute(quote(",input$enorm_predicate,"))))$design"))),
                 silent=TRUE)
    
    if(inherits(design,'try-error'))
    {
      err_message = gsub('\n',' ', as.character(design))
      #print(err_message)
      if(grepl('no such column', err_message, fixed=TRUE))
      {
        output$enorm_design_connected = renderUI({gsub('^.+no such column','unknown variable',err_message, perl=TRUE)})
      } else
      {
        output$enorm_design_connected = renderUI({'invalid predicate'})
      }
      return(NULL)
    }
  }
  
  if(nrow(design) == 0)
  {
    output$enorm_design_connected = renderUI({'no responses selected'})
    return(NULL)
  } 
  # add non printing unicode character in case item_id overlaps with booklet_id
  im = as.matrix(table(design$item_id, paste0(design$booklet_id,'\u200C')))
  
  output$enorm_design_connected = renderUI({paste0(length(unique(design$booklet_id)),
                                                   ' booklet(s), design is ',
                                                   ifelse(im_is_connected(im), 'connected', 'NOT connected'))})
  
  
  if(ncol(im) >= 80)
  {
    # too large to plot items and booklets
    # to do: some message
    wm = crossprod(im, im)
    diag(wm) = 0

    g = graph_from_adjacency_matrix(wm, mode = 'undirected',weighted=TRUE)
  } else
  {
    g = graph_from_incidence_matrix(im)
  }

  wc = cluster_walktrap(g)
  members = membership(wc)
  g = igraph_to_networkD3(g, group = members)
  forceNetwork(Links = g$links, Nodes = g$nodes, fontSize=11, zoom=TRUE,
               Source = 'source', Target = 'target', opacity=0.7,
               NodeID = 'name', Group = 'group')
  
})


output$fit_enorm_result = renderUI(
{
  req(values$parms)
  x = values$parms

  tagList(
    tags$hr(),
    tags$p(tags$i('Calibration:')),
    tags$table(
      tags$tbody(
        tags$tr(tags$th('method: '), tags$td(x$inputs$method)),
        if.else(x$inputs$method == 'CML', 
          tags$tr(tags$th('iterations: '), tags$td(x$est$n_iter)),
          tags$tr(tags$th('Gibbs samples: '), tags$td(nrow(x$est$beta.cml)))),
        if.else(x$xpr,
                tags$tr(tags$th('selection: '), tags$td(x$xpr)),
                ''),
        tags$tr(tags$th('items:'), tags$td(nrow(x$inputs$ssI))),
        tags$tr(tags$th('responses: '), tags$td(sum(x$inputs$ssIS$sufI))))))
})

go_fit_enorm = function()
{
  if(trimws(input$enorm_predicate != ''))
  {
    values$parms = eval(parse(text=paste0("fit_enorm(db, predicate={",input$enorm_predicate,"},method='",
                                            input$enorm_method,"',nIterations=",input$enorm_nIterations,")")))
    # small fix, dexter does not correctly deparse this
    values$parms$xpr = input$enorm_predicate
      
  } else
  {
    values$parms = fit_enorm(db, method=input$enorm_method, nIterations=input$enorm_nIterations)
  }
}


observeEvent(input$go_fit_enorm,{
  withBusyIndicatorServer("go_fit_enorm",{
    go_fit_enorm()
  })
})


observeEvent(input$enorm_coef_norm, { values$coef_format = 'norm'})
observeEvent(input$enorm_coef_denorm, { values$coef_format = 'denorm'})

observe({
  req(values$parms)
  if(values$parms$inputs$method=='Bayes')
  {
    hide('coef_denormalize')
  } else
  {
    show('coef_denormalize')
  }
})


enorm_coef_table = reactive({
  req(values$parms, values$coef_format)
  
  cf = coef(values$parms) 
  if(values$coef_format == "norm" || values$parms$inputs$method == 'Bayes')
  {
    cf
  } else
  {
    cf %>%
      gather('var','val', 3:4 ) %>%
      unite('temp', .data$var, .data$item_score) %>%
      spread(.data$temp, .data$val)
  }
})


output$enorm_coef = renderDataTable(
{
  req(enorm_coef_table(), values$coef_format)

  cf = enorm_coef_table() %>% 
    mutate_if(is.numeric, round, digits=3)
  if(values$coef_format == "denorm" && values$parms$inputs$method == 'CML')
  {
    cdef_target = as.list(1:(ncol(cf)-1))
    sketch = tags$table(
      class='compact',
      tags$thead(
        tags$tr(
          tags$th(''), 
          tags$th('beta', colspan=(ncol(cf)-1)/2), 
          tags$th('se', colspan=(ncol(cf)-1)/2)),
        tags$tr(do.call(tagList, 
                        lapply(c('item_id',
                                 gsub('[^\\d]','',colnames(cf)[2:ncol(cf)], perl=TRUE)), 
                               tags$th)))))
  } else 
  {
    cdef_target = if.else(values$parms$inputs$method == 'CML', 
                          list(2,3),
                          as.list(2:(ncol(cf)-1)))
    
    sketch = tags$table(tableHeader(colnames(cf)))
  }

  datatable(cf, rownames = FALSE, selection = 'none', class='compact',
            container = sketch, extensions = 'Buttons',
            options = list(dom='<"dropdown" B>lfrtip',
                           buttons =  dt_buttons('enorm_coef'),
                           pageLength = 20, scrollX = TRUE,
                           columnDefs = list(list(className = "dec-3", targets = cdef_target)),
                           fnDrawCallback = JS('dt_numcol'),
                           initComplete = JS('function(s){dtshrink(s);dt_btn_dropdown(s)}')))
})

output$enorm_coef_xl_download = downloadHandler(
  filename = function(){paste0(gsub('\\.\\w+$','',basename(db@dbname), perl=TRUE),'_enorm_coef.xlsx')},
  content = function(file) {
    write_xlsx(enorm_coef_table(), file)
  }
)
output$enorm_coef_csv_download = downloadHandler(
  filename = function(){paste0(gsub('\\.\\w+$','',basename(db@dbname), perl=TRUE),'_enorm_coef.csv')},
  content = function(file) {
    write.csv2(enorm_coef_table(), file, row.names = FALSE, fileEncoding = "utf8")
  }
)

      

# ability -----------------------------------------------------------------

observe(
{
  input$ability_method
  input$ability_prior
  if(input$ability_method == 'MLE')
  {
    runjs('hide_inputs("#ability_prior,#ability_npv,#ability_mu,#ability_sigma")')
  } else
  {
    runjs('show_inputs("#ability_prior")')
    if(input$ability_prior == 'normal')
    {
      runjs('show_inputs("#ability_npv,#ability_mu,#ability_sigma")')
    } else
    {
      runjs('hide_inputs("#ability_npv,#ability_mu,#ability_sigma")')
    }
  }
})

observe(
  {
    input$ability_tables_method
    input$ability_tables_prior
    
    runjs('hide_inputs("#ability_tables_use_draw")')
    
    if(input$ability_tables_method == 'MLE')
    {
      runjs('hide_inputs("#ability_tables_prior,#ability_tables_npv,#ability_tables_mu,#ability_tables_sigma")')
    } else
    {
      runjs('show_inputs("#ability_tables_prior")')
      if(input$ability_tables_prior == 'normal')
      {
        runjs('show_inputs("#ability_tables_npv,#ability_tables_mu,#ability_tables_sigma")')
        if(values$parms$inputs$method == 'Bayes')
          runjs('show_inputs("#ability_tables_use_draw")')
      } else
      {
        runjs('hide_inputs("#ability_tables_npv,#ability_tables_mu,#ability_tables_sigma")')
      }
    }
  })




# to do: check inputs correct
observeEvent(input$go_ability, {
  withBusyIndicatorServer("go_ability",{

    if(is.null(values$parms)) 
      go_fit_enorm()
    
    if(!(is.null(input$ability_predicate) || trimws(input$ability_predicate) == ''))
    {
      abl = eval(parse(text=paste0("ability(db, parms=values$parms, predicate={",input$ability_predicate,"},method='",input$ability_method,
                                   "',prior='",input$ability_prior,"',mu=",input$ability_mu,",sigma=",input$ability_sigma,")")))
    } else
    {
      abl = ability(db, parms = values$parms, method = input$ability_method, prior = input$ability_prior, 
                    npv = input$ability_npv, mu = input$ability_mu, sigma = input$ability_sigma )
    }
    
    
    values$person_abl = inner_join(abl, get_persons(db), by='person_id')
    
    values$abl_varinfo = lapply(select(values$person_abl, -.data$person_id, -.data$theta), function(col)
      {
        tibble(type = typeof(col), n = n_distinct(col))
      }) %>% 
      bind_rows() %>%
      add_column(name = colnames(values$person_abl)[!(colnames(values$person_abl) %in% c('person_id','theta'))])

  })
})

output$person_abilities = renderDataTable(
{
  if(!is.null(values$person_abl))
  {
    datatable( mutate_if(values$person_abl, is.double, round, digits = 3), 
               rownames = FALSE, selection = 'none', 
               class='compact', extensions = 'Buttons',
               options = list(buttons = dt_buttons('person_abilities'),
                              pageLength = 15, autoWidth=FALSE, dom='<"dropdown" B>lrtip',
                              initComplete = JS("dt_btn_dropdown")))
  }  
     
})


output$person_abilities_xl_download = downloadHandler(
  filename = function(){paste0(gsub('\\.\\w+$','',basename(db@dbname), perl=TRUE),'_abl_person.xlsx')},
  content = function(file) {
    write_xlsx(values$person_abl, file)
  }
)
output$person_abilities_csv_download = downloadHandler(
  filename = function(){paste0(gsub('\\.\\w+$','',basename(db@dbname), perl=TRUE),'_abl_person.csv')},
  content = function(file) {
    write.csv2(values$person_abl, file, row.names = FALSE, fileEncoding = "utf8")
  }
)



observeEvent(input$go_ability_tables, {
  withBusyIndicatorServer("go_ability_tables",{
    if(is.null(values$parms)) 
      go_fit_enorm()
    
    values$abl_tables = ability_tables(parms = values$parms, method = input$ability_tables_method,
                                       npv = input$ability_tables_npv, sigma = input$ability_tables_sigma,
                                       prior = input$ability_tables_prior)
      
    bkl = unique(pull(values$abl_tables, .data$booklet_id))
    
    if(is.null(isolate(input$abl_tables_plot_booklet))){
      selected = bkl
    } else
    {
      selected = intersect(bkl, isolate(input$abl_tables_plot_booklet))
    }
    
    updateSelectizeInput(session, 'abl_tables_plot_booklet', 
                         choices = bkl, selected = selected)
    
    show('abl_tables_plot_booklet')
     
  })
})

output$abl_tables = renderDataTable(
{
    if(!is.null(values$abl_tables))
    {
         mutate(values$abl_tables, theta = round(.data$theta,3), se = round(.data$se,3))
    }
},rownames = FALSE, selection = 'none', class='compact',extensions = 'Buttons',
   options = list(dom='<"dropdown" B>lfrtip',
                   buttons= dt_buttons('abl_tables'),
                   pageLength = 20, scrollX = TRUE,
                   columnDefs = list(list(className = "dec-3", targets = list(2,3))),
                   fnDrawCallback = JS('dt_numcol'),
                   initComplete = JS('dt_btn_dropdown')))

output$abl_tables_xl_download = downloadHandler(
  filename = function(){paste0(gsub('\\.\\w+$','',basename(db@dbname), perl=TRUE),'_abl.xlsx')},
  content = function(file) {
    write_xlsx(values$person_abl, file)
  }
)
output$abl_tables_csv_download = downloadHandler(
  filename = function(){paste0(gsub('\\.\\w+$','',basename(db@dbname), perl=TRUE),'_abl.csv')},
  content = function(file) {
    write.csv2(values$person_abl, file, row.names = FALSE, fileEncoding = "utf8")
  }
)

output$abl_tables_plot_ti = renderPlot({
  req(values$abl_tables, input$abl_tables_plot_booklet)

  abl = values$abl_tables %>%
      filter(is.finite(.data$theta)) %>%
      inner_join(tibble(booklet_id = input$abl_tables_plot_booklet), by='booklet_id') %>%
      mutate(I = 1/(.data$se**2))
    
  ggplot(abl, aes_string(y='I',  x='theta', group='booklet_id', colour='booklet_id')) +
      geom_line() +
      labs(x=expression(theta), title = 'Test information function') +
      expand_limits(y = 0) +
      scale_y_continuous(expand = c(0, 0)) +
      theme(panel.background = element_blank(),
            axis.line = element_line(colour = "black"),
            panel.grid.major = element_line(colour='gray88',size=0.2))

})

output$abl_tables_plot_stf = renderPlot({
  req(values$abl_tables, input$abl_tables_plot_booklet)
  
  abl = values$abl_tables %>%
      filter(is.finite(.data$theta)) %>%
      inner_join(tibble(booklet_id = input$abl_tables_plot_booklet), by='booklet_id') 
    
  ggplot(abl, aes_string(y='sumScore',  x='theta', group='booklet_id', colour='booklet_id')) +
      geom_line() +
      labs(x=expression(theta), title = 'Score transformation') +
      expand_limits(y = 0) +
      scale_y_continuous(expand = c(0, 0)) +
      theme(panel.background = element_blank(),
            axis.line = element_line(colour = "black"),
            panel.grid.major = element_line(colour='gray88',size=0.2))
    

})




observeEvent(input$abp_btn_stacked, {values$abp_stack_facet = "stacked"})
observeEvent(input$abp_btn_facetted, {values$abp_stack_facet = "facetted"})
observeEvent(input$abp_btn_joy, {values$abp_stack_facet = "joy"})


plottypes <- tibble(plot = c("hist", "box", "ecdf", "dens", "bar", "box", "line", "scat"), 
                        type = c("nominal", "nominal", "nominal", "nominal", "nominal", "nominal", "ordinal", "continuous"),
                        aim = c("dist", "dist", "dist", "dist", "comp", "comp", "comp", "rel"),
                        message = c(rep("grouping", 7), "covariate"))



observeEvent(values$person_abl,
{
  req(values$person_abl)

    
    var_info = values$abl_varinfo

    # deze keuzes kunne anders natuurlijk, even uitproberen
    firstnominal <- filter(var_info, .data$n <= 40)  %>% arrange(.data$n) %>% slice(1) 
    firstordinal <- filter(var_info,  .data$n > 1 & .data$type %in% c('integer','double')) %>% arrange(.data$n) %>% slice(1)
    firstcontinuous <- filter(var_info, .data$type %in% c('integer','double'))  %>% arrange(desc(.data$n)) %>% slice(1)
    
    if(nrow(firstordinal) == 0) plottypes <- filter(plottypes, .data$type != "ordinal")
    if(nrow(firstcontinuous) == 0) plottypes <- filter(plottypes, .data$type != "continuous")
    
    updateSelectInput(session, inputId = "abp_xvar",
                      choices = filter(var_info, .data$type %in% c('integer','double'))$name,
                      selected = firstcontinuous$name)
    

      choices <- lapply(unique(plottypes$plot), function(id)
      {
        outfile <- tempfile(fileext = '.png')
        
        if (id == "hist"){
          p <- ggplot(values$person_abl, aes_string("theta", group = firstnominal$name, fill = firstnominal$name)) +
            geom_histogram(alpha = 0.5,na.rm=TRUE, bins=30) + 
            theme(legend.position = "none") + 
            theme_nothing()} 
        else if (id == "box") {
          p <- ggplot(values$person_abl, aes_string(x = firstnominal$name, y = "theta", colour = firstnominal$name)) +
            geom_boxplot(na.rm=TRUE) +
            theme(legend.position = "none") + 
            theme_nothing()} 
        else if (id == "ecdf") {
          p <- ggplot(values$person_abl, aes_string("theta", colour = firstnominal$name)) +
            stat_ecdf(na.rm=TRUE) + 
            theme_nothing()} 
        else if (id == "dens") {
          p <- ggplot(values$person_abl, aes_string("theta")) +
            geom_density(aes_string(group = firstnominal$name, colour = firstnominal$name),na.rm=TRUE) + 
            theme_nothing()} 
        else if (id == "bar") {
          p <- ggplot(values$person_abl, aes_string(firstnominal$name, "theta", fill = firstnominal$name)) +
            geom_bar(stat = "summary", fun.y = "mean",na.rm=TRUE) +
            theme(legend.position = "none") + 
            theme_nothing()} 
        else if (id == "line") {
          p <- ggplot(values$person_abl, aes_string(firstordinal$name, "theta", fill = firstnominal$name, colour = firstnominal$name)) +
            geom_line(stat = "summary", fun.y = "mean", na.rm=TRUE) + 
            theme_nothing()} 
        else if (id == "scat") {
          p <- ggplot(values$person_abl, aes_string(firstcontinuous$name, "theta", colour = firstnominal$name)) + 
            geom_point(na.rm=TRUE) + 
            theme_nothing()}
      
      ggsave(outfile, p, width = 1, height = 1)
      
      list(src = outfile,
           contentType = 'image/png',
           choice_id = id,
           group = ifelse(id %in% c("hist", "box", "ecdf", "dens"), 'distr', 
                          ifelse(id %in% c("bar", "line"), 'comp', 'rel')))
    })

  
  group_options <- list(distr = list(label = 'Distribution'),
                        comp = list(label = 'Comparison'),
                        rel = list(label = 'Relationships'))
  
  choices[[2]]$group = c('distr', 'comp')
  
  updateImgSelect(session, choices = choices, inputId = "abp_plotbar", group_options = group_options, selected = "hist")
  
})



observeEvent({input$abp_plotbar; values$abl_varinfo},
{
  if(is.null(values$abl_varinfo))
  {
    hide(selector=paste0('#abp_group,#abp_main,#abp_xlab,#abp_ylab,#abp_grid,#abp_bins,#abp_fill,',
                         '#abp_linetype,#abp_fitlines,#abp_xvar,#abp_color,#abp_stackfacet,#abp_trans'))

  } else if(!(is.null(input$abp_plotbar$value)))
  {
    var_info = values$abl_varinfo
    
    # sorteren?
    nominal_var = filter(var_info, .data$n <= 40) 
    ordinal_var = filter(var_info,  .data$n > 1 & .data$type %in% c('integer','double'))
    continuous_var = filter(var_info, .data$type %in% c('integer','double')) 
    
    firstnominal <-  nominal_var %>% slice(1)
    firstordinal <-  ordinal_var %>% slice(1)
    firstcontinuous <-  continuous_var %>% slice(1)
    
    if(nrow(firstordinal) == 0) plottypes <- filter(plottypes, .data$type != "ordinal")
    if(nrow(firstcontinuous) == 0) plottypes <- filter(plottypes, .data$type != "continuous")
    
    
    currentgroup <- input$abp_group
    if (currentgroup %in% pull(nominal_var, 'name')) {
      barboxgroup <- input$abp_group
    } else {barboxgroup <- firstnominal$name}
    
    if (input$abp_plotbar$value %in% c("hist", "dens", "ecdf", "line", "scat")) {
      updateSelectInput(session, 
                        inputId = "abp_group", 
                        choices = c("none", pull(nominal_var, 'name')),
                        selected = currentgroup)
    } else if (input$abp_plotbar$value %in% c("box", "bar")) {
      updateSelectInput(session,
                        inputId = "abp_group",
                        choices = pull(nominal_var, 'name'),
                        selected = barboxgroup)
    }
    
    if (input$abp_plotbar$value == "scat"){
      updateSelectInput(session,
                        inputId = "abp_xvar",
                        choices = pull(continuous_var, 'name'),
                        selected = input$abp_xvar)
    } else if (input$abp_plotbar$value == "line"){
      updateSelectInput(session,
                        inputId = "abp_xvar",
                        choices = pull(ordinal_var, 'name'),
                        selected = input$abp_xvar)
    }
    
    show(id = "abp_group")
    show(id = "abp_main")
    show(id = "abp_xlab")
    show(id = "abp_ylab")
    show(id = "abp_grid")
    
    if (input$abp_plotbar$value == "hist") {show(id = "abp_bins")} else {hide(id = "abp_bins")}
    if (input$abp_plotbar$value %in% c("box", "dens")) {show(id = "abp_fill")} else hide(id = "abp_fill")
    # if (input$abp_plotbar$value == "bar") {show(id = "abp_dodge")} else {hide(id = "abp_dodge")}
    # if (input$abp_plotbar$value %in% c("bar", "line")){show(id = "abp_err")} else {hide(id = "abp_err")}
    # if (input$abp_plotbar$value == "scat") {show(id = "abp_marg")} else {hide(id = "abp_marg")}
    if (input$abp_plotbar$value == "line") {show(id = "abp_linetype")} else {hide(id = "abp_linetype")}
    if (input$abp_plotbar$value == "scat") {show(id = "abp_fitlines")} else {hide(id = "abp_fitlines")}
    if (input$abp_plotbar$value %in% c("line", "scat")) {show(id = "abp_xvar")} else {hide(id = "abp_xvar")}
    

    if (input$abp_group %in% pull(nominal_var, 'name') &&
          input$abp_plotbar$value %in% c("hist", "dens")) {
      show(id = "abp_stackfacet")
    } else {hide(id = "abp_stackfacet")}

    

    if (input$abp_plotbar$value %in% c("hist", "ecdf", "dens", "line", "scat") & input$abp_group == "none") {show(id = "abp_color")} 
    else {hide(id = "abp_color")}

    

    if (input$abp_fill == TRUE && input$abp_plotbar$value %in% c("hist", "box", "dens", "bar")) {
      show(id = "abp_trans")
    } else { hide(id = "abp_trans") }

  }
})

observe(
  {
    # haalt gekozen group var weg uit x var indien nodig
    req(values$abl_varinfo, input$abp_plotbar$value)

    if(input$abp_plotbar$value %in% c('scat','line'))
    {
      # dit stukje is verdubbeling van code, beter functie van maken
      var_info = values$abl_varinfo
      ordinal_var = filter(var_info,  .data$n > 1 & .data$type %in% c('integer','double'))
      continuous_var = filter(var_info, .data$type %in% c('integer','double'))

      if(input$abp_plotbar$value == 'line')
      {
        selected = if.else(input$abp_group == isolate(input$abp_xvar), NULL, isolate(input$abp_xvar))
        updateSelectInput(session,
                          inputId = "abp_xvar",
                          choices = setdiff(pull(ordinal_var, 'name'), input$abp_group),
                          selected = selected)

      } else if(input$abp_plotbar$value == 'scat')
      {
        selected = if.else(input$abp_group == isolate(input$abp_xvar), NULL, isolate(input$abp_xvar))
        updateSelectInput(session,
                          inputId = "abp_xvar",
                          choices = setdiff(pull(continuous_var, 'name'),input$abp_group),
                          selected = selected)
      }

    }
  }, priority=1)



abplot = reactive({
  req(input$abp_plotbar$value, values$person_abl, 
      !((input$abp_xvar == '' || input$abp_xvar == input$abp_group) && input$abp_plotbar$value %in% c('scat','line')))


    switch(input$abp_plotbar$value,
        
           # HISTOGRAM
           hist = {
             
             if (input$abp_group == "none"){
               p <- ggplot(values$person_abl, aes_string("theta")) + 
                 geom_histogram(fill = input$abp_color, alpha = input$abp_trans, bins = input$abp_bins,na.rm=TRUE)
             } else if (input$abp_group != "none" && values$abp_stack_facet != "joy") {
               p <- ggplot(values$person_abl %>% mutate(!!input$abp_group := as.factor(.data[[input$abp_group]])), 
                           aes_string("theta", fill = input$abp_group)) + 
                 geom_histogram(alpha = input$abp_trans, bins = input$abp_bins,na.rm=TRUE)
               
               if (values$abp_stack_facet == 'facetted') {
                 p <- p + 
                   facet_grid(reformulate(input$abp_group, "."))
               }
               
             } else if (input$abp_group != "none" && values$abp_stack_facet == "joy") {
               p <- ggplot(values$person_abl %>% mutate(!!input$abp_group := as.factor(.data[[input$abp_group]])), 
                           aes_string(x = "theta", 
                                      y = input$abp_group, 
                                      group = input$abp_group, 
                                      fill = input$abp_group)) +
                 geom_density_ridges2(stat = "binline", bins = input$abp_bins,
                                      show.legend = FALSE, alpha = input$abp_trans,
                                      na.rm=TRUE)
             }
             
             p <- p + 
               theme(legend.position = "none") +
               theme_minimal()
             
           },
           
           # BOX PLOT
           box = {
             
             p <- ggplot(values$person_abl %>% mutate(!!input$abp_group := as.factor(.data[[input$abp_group]])), 
                         aes_string(x = input$abp_group, y = "theta", 
                                              colour = input$abp_group)) +
               geom_boxplot(alpha = input$abp_trans, show.legend = FALSE, na.rm=TRUE) +
               theme_minimal()
             
             if (input$abp_fill == TRUE){
               p <- p + aes_string(fill = input$abp_group)
             }
             
           },
           
           # ECDF
           ecdf = {
             
             if (input$abp_group != "none"){
               p <- ggplot(values$person_abl %>% mutate(!!input$abp_group := as.factor(.data[[input$abp_group]])), 
                           aes_string("theta", color = input$abp_group)) +
                 stat_ecdf(na.rm=TRUE)
             } else if (input$abp_group == "none"){
               p <- ggplot(values$person_abl, aes_string("theta")) +
                 stat_ecdf(color = input$abp_color,na.rm=TRUE)
             }
             
             p <- p + 
               theme_minimal()
             
           },
           
           # DENSITY PLOT
           dens = {
             
             #print(paste('stack',values$abp_stack_facet))
             if(input$abp_group == "none")
             {
                p <- ggplot(values$person_abl, aes_string("theta"))
             } else
             {
               p <- ggplot(values$person_abl %>% mutate(!!input$abp_group := as.factor(.data[[input$abp_group]])),
                           aes_string("theta"))
             }
             
             
             if (input$abp_group != "none" && values$abp_stack_facet != "joy") {
               p <- p + geom_density(aes_string(group = input$abp_group, 
                                                colour = input$abp_group),
                                     alpha = input$abp_trans,na.rm=TRUE)
               
               if (values$abp_stack_facet == 'facetted') {
                 p <- p + 
                   facet_grid(reformulate(input$abp_group, "."))
               }
               
               if (input$abp_fill == TRUE) {
                 p <- p + aes_string(fill = input$abp_group)
               }
               
             } else if (input$abp_group != "none" && values$abp_stack_facet == "joy") {

               p <- ggplot(filter(values$person_abl, is.finite(.data$theta)), aes_string(x = "theta", 
                                                y = input$abp_group, 
                                                group = input$abp_group)) +
                 geom_density_ridges2(show.legend = FALSE, alpha = input$abp_trans,na.rm=TRUE)
               
               if (input$abp_fill == TRUE) {
                 p <- p + aes_string(fill = input$abp_group)
               }
               
             } else if (input$abp_group == "none" && input$abp_fill == TRUE) {
               p <- p + geom_density(color = input$abp_color, 
                                     fill = input$abp_color,
                                     alpha = input$abp_trans,na.rm=TRUE)
             } else if (input$abp_group == "none" && input$abp_fill == FALSE) {
               p <- p + geom_density(color = input$abp_color,
                                     alpha = input$abp_trans,na.rm=TRUE)
             }
             
             p <- p + theme_minimal()
             
           },
           
           # error bars
           # dodge
           
           # BAR CHART
           bar = {
             
             updateCheckboxInput(session, "abp_fill", value = TRUE)
             
             p <- ggplot(values$person_abl, aes_string(input$abp_group, "theta")) +
               geom_bar(stat = "summary", fun.y = "mean", 
                        show.legend = FALSE,
                        alpha = input$abp_trans,
                        na.rm=TRUE) +
               aes_string(fill = input$abp_group) +
               theme_minimal()
             
           },
           
           # LINE CHART
           line = {
             
             if (input$abp_group == "none"){
               hide(id = "abp_linetype")
             } else {show(id = "abp_linetype")}
             
             p <- ggplot(if.else(input$abp_group == 'none',
                                 values$person_abl,
                                 values$person_abl %>% mutate(!!input$abp_group := as.factor(.data[[input$abp_group]]))),
                                 aes_string(input$abp_xvar, "theta")) +
               theme_minimal()
             
             if (input$abp_group == "none"){
               p <- p + geom_line(stat = "summary", fun.y = "mean", colour = input$abp_color, na.rm=TRUE)
             } else if (input$abp_group != "none"){
               p <- p + geom_line(stat = "summary", fun.y = "mean", na.rm=TRUE) +
                 aes_string(fill = input$abp_group, colour = input$abp_group)
               
               if (input$abp_linetype == TRUE) {
                 p <- p + aes_string(linetype = input$abp_group)
               }
             }
             
             
           },
           
           # marg       marginal plots
           
           # SCATTERPLOT
           scat = {
             
             p <- ggplot(if.else(input$abp_group == 'none',
                                 values$person_abl,
                                 values$person_abl %>% mutate(!!input$abp_group := as.factor(.data[[input$abp_group]]))),
                         aes_string(input$abp_xvar, "theta")) + 
               theme_minimal()
             
             if (input$abp_group == "none"){
               p <- p + 
                 geom_point(color = input$abp_color,na.rm=TRUE)
               
               # if (input$abp_marg == TRUE){
               #   ggExtra::ggMarginal(p, type = "density", margins = "both", size = 4, marginCol = "red")
               # }
               
             } else if (input$abp_group != "none"){
               p <- p + 
                 geom_point(na.rm=TRUE) +
                 aes_string(colour = input$abp_group)
             }
             
             if (input$abp_fitlines == TRUE){
               p <- p + geom_smooth() # method = lm ?
             }
             
           }
    )
    
    if (input$abp_xlab != "") {p <- p + xlab(input$abp_xlab)}
    if (input$abp_ylab != "") {p <- p + ylab(input$abp_ylab)}
    if (input$abp_main != "") {p <- p + ggtitle(input$abp_main) +
      theme(plot.title = element_text(size = 20,
                                      hjust = 0.5))}
    if (input$abp_grid == FALSE){
      p <- p + theme(panel.grid.major = element_blank(), 
                     panel.grid.minor = element_blank())
    }

    p
    
})

output$abp_plot = renderPlot({abplot()})

output$abp_download = downloadHandler(
  filename = function(){paste0(gsub('\\.\\w+$','',basename(db@dbname), perl=TRUE),'_ability.png')},
  content = function(file) {
    
    png()
    plt = abplot() +  theme(axis.text = element_text(size = 8),
                            axis.title = element_text(size = 8),
                            legend.text = element_text(size = 8),
                            legend.title = element_text(size = 8),
                            legend.key.size = unit(0.4,"cm"))

    ggsave(file, plot = plt, device = "png", units = 'cm', 
           width = input$abp_download_width, height = input$abp_download_height,
           dpi = 600)
  },
  contentType = "image/png"
)


      
      

}
  
  shinyApp(get_ui(), server)
}

