% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cwrapper.R
\name{dgGEO_to_Q2DD}
\alias{dgGEO_to_Q2DD}
\title{Convert from GEO to Q2DD}
\usage{
dgGEO_to_Q2DD(dggs, in_lon_deg, in_lat_deg)
}
\arguments{
\item{dggs}{A dggs object from dgconstruct()}

\item{in_lon_deg}{Vector of longitude, in degrees}

\item{in_lat_deg}{Vector of latitude, in degrees}
}
\value{
Returns a dggs object which can be passed to other dggridR
            functions
}
\description{
Uses a discrete global grid system to convert between GEO
            and Q2DD (see vignette for details)
}
\examples{
\dontrun{
library(dggridR)
dggs <- dgconstruct(res=20)

dgGEO_to_Q2DD(dggs, in_lon_deg, in_lat_deg)
}

}
