% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dggridR.R
\name{dgmaxcell}
\alias{dgmaxcell}
\title{Get largest cell id for a dggs}
\usage{
dgmaxcell(dggs, res = NA)
}
\arguments{
\item{dggs}{A dggs object from dgconstruct()}

\item{res}{If NA, use the resolution specified by the dggs. Otherwise,
override the resolution.}
}
\value{
The maximum cell id.
}
\description{
Cells are labeled 1-N. This function returns N. This is useful if
            you want to choose cells from the dggs randomly.
}
\examples{
#Choose a set of cells randomly distributed over the Earth
library(dggridR)
dggs    <- dgconstruct(spacing=1000, metric=FALSE, resround='down')
N       <- 100                                 #Number of cells
maxcell <- dgmaxcell(dggs)                     #Get maximum cell id
cells   <- sample(1:maxcell, N, replace=FALSE) #Choose random cells
grid    <- dgcellstogrid(dggs,cells,frame=TRUE,wrapcells=TRUE) #Get grid
}
