% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dgp.R
\name{continue}
\alias{continue}
\title{Continue the training of a DGP emulator}
\usage{
continue(
  object,
  N = 500,
  cores = 1,
  ess_burn = 10,
  verb = TRUE,
  burnin = NULL,
  B = NULL
)
}
\arguments{
\item{object}{an instance of the \code{dgp} class.}

\item{N}{additional number of iterations for the DGP emulator training. Defaults to \code{500}.}

\item{cores}{the number of cores/workers to be used to optimize GP components (in the same layer)
at each M-step of the training. If set to \code{NULL}, the number of cores is set to \verb{(max physical cores available - 1)}.
Only use multiple cores when there is a large number of GP components in different layers and optimization of GP components
is computationally expensive. Defaults to \code{1}.}

\item{ess_burn}{number of burnin steps for the ESS-within-Gibbs
at each I-step of the training. Defaults to \code{10}.}

\item{verb}{a bool indicating if the progress bar will be printed during the training:
\enumerate{
\item \code{FALSE}: the training progress bar will not be displayed.
\item \code{TRUE}: the training progress bar will be displayed.
}

Defaults to \code{TRUE}.}

\item{burnin}{the number of training iterations to be discarded for
point estimates calculation. Must be smaller than the overall training iterations
so-far implemented. If this is not specified, only the last 25\% of iterations
are used. This overrides the value of \code{burnin} set in \code{\link[=dgp]{dgp()}}. Defaults to \code{NULL}.}

\item{B}{the number of imputations to produce the predictions. Increase the value to account for
more imputation uncertainties. This overrides the value of \code{B} set in \code{\link[=dgp]{dgp()}} if \code{B} is not
\code{NULL}. Defaults to \code{NULL}.}
}
\value{
An updated \code{object}.
}
\description{
This function implements additional training iterations for a DGP emulator.
}
\details{
See further examples and tutorials at \url{https://mingdeyu.github.io/dgpsi-R/}.
}
\note{
\itemize{
\item One can also use this function to fit an untrained DGP emulator constructed by \code{\link[=dgp]{dgp()}} with \code{training = FALSE}.
\item The following slots:
\itemize{
\item \code{loo} and \code{oos} created by \code{\link[=validate]{validate()}}; and
\item \code{results} created by \code{\link[=predict]{predict()}}
in \code{object} will be removed and not contained in the returned object.
}
}
}
\examples{
\dontrun{

# See dgp() for an example.
}
}
