#' Block Matrix
#'
#' @name block_matrix
#' @param x a square matrix where the dimensions are integer multiples of size or integer dividors of steps
#' @param steps the required number of steps (block matrices) across the diagonal
#' @param size the width or height of the matrix being dropped over the diagonal of matrix x
#' @param replacement value to be inserted on the diagonal, by default this is zero (0).
#' @details Either steps or size is expected to be provided.
#' @export
#' @examples
#' # create a square matrix
#' m <- matrix(1:64, nrow=8)
#'
#' # select a block matrix with two steps
#' block_matrix(m, steps=2)
#'
#' # select a block matrix with four steps
#' block_matrix(m, steps=4)
#'

block_matrix <- function( x, steps = NULL, size = NULL, replacement = 0 ) {

  # create the off diagonal matrix (because programatically easier)
  # to be substracted from x to form the output
  y <- minus_block_matrix(x = x, steps = steps, size = size, replacement = replacement )

  # replacement is substracted on the diagonal with y
  # here it is added for the whole of x
  # cancelling out on the diagonal
  # and adding off diagonal
  return(x - y + replacement)

}
