
context("qualitative parameter objects")

test_that('param ranges', {
  expect_equal(min_n(1:2)$range, list(lower = 1L, upper = 2L))
  expect_equal(sample_size(1:2)$range, list(lower = 1L, upper = 2L))
  expect_equal(learn_rate(c(.1, .9))$range, list(lower = 0.1, upper = 0.9))
  expect_equal(loss_reduction(c(.1, .9))$range, list(lower = 0.1, upper = 0.9))
  expect_equal(cost_complexity(c(.1, .9))$range, list(lower = 0.1, upper = 0.9))
  expect_equal(epochs(1:2)$range, list(lower = 1L, upper = 2L))
  expect_equal(degree()$range, list(lower = 1, upper = 3))
  expect_equal(degree_int()$range, list(lower = 1L, upper = 3L))
  expect_equal(spline_degree()$range, list(lower = 3L, upper = 10L))
  expect_equal(spline_degree()$range, list(lower = 3L, upper = 10L))
  expect_equal(prod_degree(1:2)$range, list(lower = 1L, upper = 2L))
  expect_equal(num_terms(1:2)$range, list(lower = 1L, upper = 2L))
  expect_equal(num_comp(1:2)$range, list(lower = 1L, upper = 2L))
  expect_equal(cost(c(-2.0, -1.0))$range, list(lower = -2, upper = -1))
  expect_equal(scale_factor(c(-2.0, -1.0))$range, list(lower = -2, upper = -1))
  expect_equal(svm_margin(c(.1, .15))$range, list(lower = .1, upper = .15))
  expect_equal(deg_free(1:2)$range, list(lower = 1L, upper = 2L))
  expect_equal(hidden_units(1:2)$range, list(lower = 1L, upper = 2L))
  expect_equal(batch_size(1:2)$range, list(lower = 1L, upper = 2L))
  expect_equal(Laplace(c(.1, .9))$range, list(lower = 0.1, upper = 0.9))
  expect_equal(dist_power(c(.1, .9))$range, list(lower = 0.1, upper = 0.9))
  expect_equal(threshold(c(.1, .15))$range, list(lower = .1, upper = .15))
  expect_equal(weight(c(-2.0, -1.0))$range, list(lower = -2, upper = -1))
  expect_equal(max_times(1:2)$range, list(lower = 1L, upper = 2L))
  expect_equal(min_times(1:2)$range, list(lower = 1L, upper = 2L))
  expect_equal(max_tokens(1:2)$range, list(lower = 1L, upper = 2L))
  expect_equal(window_size(c(3L, 5L))$range, list(lower = 3L, upper = 5L))
  expect_equal(neighbors()$range, list(lower = 1L, upper = 10L))
  expect_equal(neighbors(1:2)$range, list(lower = 1L, upper = 2L))
  expect_equal(num_breaks()$range, list(lower = 2L, upper = 10L))
  expect_equal(num_breaks(1:2)$range, list(lower = 1L, upper = 2L))
  expect_equal(min_unique()$range, list(lower = 5L, upper = 15L))
  expect_equal(min_unique(1:2)$range, list(lower = 1L, upper = 2L))
  expect_equal(freq_cut(c(1.0, 2.0))$range, list(lower = 1, upper = 2))
  expect_equal(unique_cut(c(1.0, 2.0))$range, list(lower = 1, upper = 2))
  expect_equal(over_ratio(c(.5, 1.5))$range, list(lower = .5, upper = 1.5))
  expect_equal(under_ratio(c(.5, 1.5))$range, list(lower = .5, upper = 1.5))
  expect_equal(rbf_sigma(c(-2.0, -1.0))$range, list(lower = -2, upper = -1))
  expect_equal(kernel_offset(c(0.0, 1.0))$range, list(lower = 0, upper = 1))
  expect_equal(min_dist(c(-2.0, -1.0))$range, list(lower = -2, upper = -1))
  expect_equal(sample_prop(c(.5, .6))$range, list(lower = .5, upper = .6))
  expect_equal(num_hash(1:2)$range, list(lower = 1, upper = 2))
  expect_equal(smoothness(c(.25, 1.75))$range, list(lower = .25, upper = 1.75))
})


test_that('param values', {
  expect_equal(token(letters[1:3])$values, letters[1:3])
  expect_equal(weight_scheme(letters[1:3])$values, letters[1:3])
  expect_equal(prune_method(letters[1:3])$values, letters[1:3])
  expect_equal(weight_func(letters[1:3])$values, letters[1:3])
  expect_equal(weight_func(letters[1:3])$values, letters[1:3])
  expect_equal(signed_hash(TRUE)$values, TRUE)
})

