% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute.R
\name{impute_missing}
\alias{impute_missing}
\title{Impute missing values}
\usage{
impute_missing(E, data, nk)
}
\arguments{
\item{E}{4D array of clusterings from \code{consensus_cluster}. The number of
rows is equal to the number of cases to be clustered, number of columns is
equal to the clusterings obtained by different resamplings of the data, the
third dimension are the different algorithms and the fourth dimension are
cluster sizes.}

\item{data}{data matrix with samples as rows and genes/features as columns}

\item{nk}{cluster size to extract data for (single value)}
}
\value{
If flattened matrix consists of more than one repetition, i.e. it
  isn't a column vector, then the function returns a matrix of clusterings
  with complete cases imputed using majority voting, and relabelled, for
  chosen \code{k}.
}
\description{
Impute missing values from bootstrapped subsampling
}
\details{
The default output from \code{consensus_cluster} will undoubtedly contain
\code{NA} entries because each replicate chooses a random subset (with
replacement) of all samples. Missing values should first be imputed using
\code{\link{impute_knn}}. Not all missing values are guaranteed to be imputed
by KNN. See \code{\link[class]{knn}} for details. Thus, any remaining missing
values are imputed using majority voting.
}
\examples{
data(hgsc)
dat <- hgsc[1:100, 1:50]
E <- consensus_cluster(dat, nk = 3:4, reps = 10, algorithms = c("hc", "km",
"sc"), progress = FALSE)
sum(is.na(E))
E_imputed <- impute_missing(E, dat, 4)
sum(is.na(E_imputed))
}
\seealso{
Other imputation functions: \code{\link{impute_knn}}
}
\author{
Aline Talhouk
}
