% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/difORD.R
\name{coef.difORD}
\alias{coef.difORD}
\alias{coefficients.difORD}
\title{Extract model coefficients from an object of \code{"difORD"} class.}
\usage{
\method{coef}{difORD}(object, SE = FALSE, simplify = FALSE, ...)
}
\arguments{
\item{object}{an object of \code{"difORD"} class.}

\item{SE}{logical: should the standard errors of estimated parameters be also returned? (default is \code{FALSE}).}

\item{simplify}{logical: should the estimated parameters be simplified to a matrix? (default is \code{FALSE}).}

\item{...}{other generic parameters for \code{coef()} method.}
}
\description{
S3 method for extracting estimated model coefficients from an object of \code{"difORD"} class.
}
\examples{
\dontrun{
# Loading data
data(dataMedicalgraded, package = "ShinyItemAnalysis")
Data <- dataMedicalgraded[, 1:5]
group <- dataMedicalgraded[, 101]

# Testing both DIF effects with adjacent category logit model
(x <- difORD(Data, group, focal.name = 1, model = "adjacent"))

# Estimated parameters
coef(x)
coef(x, SE = TRUE)
coef(x, simplify = TRUE)
coef(x, SE = TRUE, simplify = TRUE)
}
}
\seealso{
\code{\link[difNLR]{difORD}} for DIF detection among ordinal data. \cr
\code{\link[stats]{coef}} for generic function extracting model coefficients.
}
\author{
Adela Hladka (nee Drabinova) \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
Faculty of Mathematics and Physics, Charles University \cr
\email{hladka@cs.cas.cz} \cr

Patricia Martinkova \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
\email{martinkova@cs.cas.cz} \cr
}
