% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffEnrich.R
\name{diffEnrich}
\alias{diffEnrich}
\alias{print.diffEnrich}
\alias{summary.diffEnrich}
\title{diffEnrich}
\usage{
diffEnrich(list1_pe, list2_pe, method = "BH", cutoff = 0.05)

\method{print}{diffEnrich}(x, ...)

\method{summary}{diffEnrich}(object, ...)
}
\arguments{
\item{list1_pe}{object of class \code{pathEnrich} generated from \code{\link{pathEnrich}}.
See example for \code{\link{pathEnrich}}.}

\item{list2_pe}{object of class \code{pathEnrich} generated from \code{\link{pathEnrich}}.
See example for \code{\link{pathEnrich}}.}

\item{method}{character. Character string telling \code{diffEnrich} which method to
use for multiple testing correction. Available methods are thos provided by
\code{\link{p.adjust}}, and the default is "BH", or False Discovery Rate (FDR).}

\item{cutoff}{Numeric. The p-value threshold to be used as the cutoff when determining statistical significance, and used to filter list of significant pathways.}

\item{x}{object of class \code{diffEnrich}}

\item{\dots}{Unused}

\item{object}{object of class \code{diffEnrich}}
}
\value{
A list object of class \code{diffEnrich} that contains 5 items:

\describe{
\item{species}{The species used in enrichment}
\item{padj}{The method used to correct for multiple testing for the differential enrichment}
\item{sig_paths}{The KEGG pathways the reached statistical significance after multiple testing correction.}
\item{path_intersect}{the number of pathways that were shared (and therefore tested) between the gene lists.}
\item{de_table}{A data frame that summarizes the results of the differential enrichment analysis and contains the following variables:}
}

\describe{
  \item{KEGG_PATHWAY_ID}{KEGG Pathway Identifier}
  \item{KEGG_PATHWAY_description}{Description of KEGG Pathway (provided by KEGG)}
  \item{KEGG_PATHWAY_cnt}{Number of Genes in KEGG Pathway}
  \item{KEGG_DATABASE_cnt}{Number of Genes in KEGG Database}
  \item{KEGG_PATHWAY_in_list1}{Number of Genes from gene list 1 in KEGG Pathway}
  \item{KEGG_DATABASE_in_list1}{Number of Genes from gene list 1 in KEGG Database}
  \item{expected_list1}{Expected number of genes from list 1 to be in KEGG pathway by chance (i.e., not enriched)}
  \item{enrich_p_list1}{P-value for enrichment of list 1 genes related to KEGG pathway}
  \item{p_adj_list1}{Multiple testing adjustment of enrich_p_list1 (default = False Discovery Rate (Benjamini and Hochberg))}
  \item{fold_enrichment_list1}{KEGG_PATHWAY_in_list1/expected_list1}
  \item{KEGG_PATHWAY_in_list2}{Number of Genes from gene list 2 in KEGG Pathway}
  \item{KEGG_DATABASE_in_list2}{Number of Genes from gene list 2 in KEGG Database}
  \item{expected_list2}{Expected number of genes from list 2 to be in KEGG pathway by chance (i.e., not enriched)}
  \item{enrich_p_list2}{P-value for enrichment of list 2 genes related to KEGG pathway}
  \item{p_adj_list2}{Multiple testing adjustment of enrich_p_list2 (default = False Discovery Rate (Benjamini and Hochberg))}
  \item{fold_enrichment_list2}{KEGG_PATHWAY_in_list2/expected_list2}
  \item{odd_ratio}{Odds of a gene from list 2 being from this KEGG pathway / Odds of a gene from list 1 being from this KEGG pathway}
  \item{diff_enrich_p}{P-value for differential enrichment of this KEGG pathway between list 1 and list 2}
  \item{diff_enrich_adjusted}{Multiple testing adjustment of diff_enrich_p (default = False Discovery Rate (Benjamini and Hochberg))}
}
}
\description{
This function takes the objects generated from \code{\link{pathEnrich}}.
If performing a dfferential enrichment analysis, the user will have 2 objects. There
will be one for the genes of interest in gene list 1 and one for the genes of interest in gene list 2 (see example for \code{\link{pathEnrich}}).
This function then uses a Fisher's Exact test to identify differentially enriched
pathways between the terms enriched in the gene-of-interest lists. \code{diffEnrich}
will remove KEGG pathways that do not contain any genes from either gene list as these
cannot be tested, and will print a warning message telling the user how many pathways
were removed.
\code{diffEnrich} returns a dataframe containing differentially enriched
pathways with their associated estimated odds ratio, unadjusted p-value, and fdr adjusted
p-value. S3 generic functions for \code{print} and \code{summary} are
provided. The \code{print} function prints the results table as a \code{tibble}, and the
\code{summary} function returns the number of pathways that reached statistical significance
as well as their descriptions, the number of genes used from the KEGG data base, the KEGG species,
the number of pathways that were shared (and therefore tested) between the gene lists and the
method used for multiple testing correction.
}
\examples{
## Generate individual enrichment reults
list1_pe <- pathEnrich(gk_obj = kegg, gene_list = geneLists$list1)
list2_pe <- pathEnrich(gk_obj = kegg, gene_list = geneLists$list2)

## Perform differential enrichment
dif_enrich <- diffEnrich(list1_pe = list1_pe, list2_pe = list2_pe, method = 'none', cutoff = 0.05)

}
