% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_search_diff.R
\name{find_id_obs_risque}
\alias{find_id_obs_risque}
\title{Recuperer les identifiants des observations a risque}
\usage{
find_id_obs_risque(list_agregat, t_ind, threshold, verbose = TRUE)
}
\arguments{
\item{list_agregat}{Liste de vecteurs de chaînes de caracteres donnant les noms
des zones de z1 constituant les differents agregats. Ces agregats ont dû
prealablement être identifies comme conduisant a un probleme de differenciation.}

\item{t_ind}{La table individuelle donnant pour chaque observation la zone de z1
et la zonne de z2 auquelle elle appartient.}

\item{threshold}{Entier indiquant le threshold de confidentialite.}

\item{verbose}{Boolean. If TRUE, progress bar is displayed.}
}
\value{
En sortie on obtient un data.frame/data.table donnant la liste
des observations a risque, sans doublons, et indiquant pour chaque observation
a risque, l'agregat sur lequel la differenciation est faite, le type de differenciation
(interne ou externe), la taille de l'agregat (nombre de zones de z1) et le nombre
d'observations a risque dans la même differenciation
}
\description{
Permet de recuperer les identifiants des observations a
risque de differenciation. Permet egalement de donner le nombre
d'observations qu'il y a sur les zones "internes" et "externes"
lorsqu'on effectue la differenciation.
}
\details{
Il se peut que certains agregats conduisent au même probleme de differenciation,
c'est-a-dire qu'ils permettent de deduire de l'information sur le même
groupe d'observation. Dans ce cas, cette fonction ne garde que l'agregat de plus
petite taille (en terme de nombre de zones de z1 impliques dans l'agregat). Il
se peut donc qu'en sortie, le nombre d'agregats soit inferieur au nombre d'agregats
en entree.
}
