% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\name{barPlotCellTypes}
\alias{barPlotCellTypes}
\alias{barPlotCellTypes,DigitalDLSorter-method}
\alias{barPlotCellTypes,ANY-method}
\title{Bar plot of deconvoluted cell type proportions in bulk RNA-Seq samples}
\usage{
barPlotCellTypes(
  data,
  colors = NULL,
  simplify = NULL,
  color.line = NA,
  x.label = "Bulk samples",
  rm.x.text = FALSE,
  title = "Results of deconvolution",
  legend.title = "Cell types",
  angle = 90,
  theme = NULL,
  ...
)

\S4method{barPlotCellTypes}{DigitalDLSorter}(
  data,
  colors = NULL,
  simplify = NULL,
  color.line = NA,
  x.label = "Bulk samples",
  rm.x.text = FALSE,
  title = "Results of deconvolution",
  legend.title = "Cell types",
  angle = 90,
  theme = NULL,
  name.data = NULL
)

\S4method{barPlotCellTypes}{ANY}(
  data,
  colors,
  color.line = NA,
  x.label = "Bulk samples",
  rm.x.text = FALSE,
  title = "Results of deconvolution",
  legend.title = "Cell types",
  angle = 90,
  theme = NULL
)
}
\arguments{
\item{data}{\code{\linkS4class{DigitalDLSorter}} object with
\code{deconv.results} slot or a data frame/matrix with cell types as
columns and samples as rows.}

\item{colors}{Vector of colors to be used.}

\item{simplify}{Type of simplification performed during deconvolution. Can be
\code{simpli.set} or \code{simpli.maj} (\code{NULL} by default). It is only
for \code{\linkS4class{DigitalDLSorter}} objects.}

\item{color.line}{Color of the border bars.}

\item{x.label}{Label of x-axis.}

\item{rm.x.text}{Logical value indicating whether to remove x-axis ticks
(name of samples).}

\item{title}{Title of the plot.}

\item{legend.title}{Title of the legend plot.}

\item{angle}{Angle of text ticks.}

\item{theme}{\pkg{ggplot2} theme.}

\item{...}{Other arguments for specific methods.}

\item{name.data}{If a \code{\linkS4class{DigitalDLSorter}} is given, name of
the element that stores the results in the \code{deconv.results} slot.}
}
\value{
A ggplot object with the provided cell proportions represented as a
bar plot.
}
\description{
Bar plot of deconvoluted cell type proportions in bulk RNA-Seq samples.
}
\examples{
# matrix of simulated proportions (same estructure as deconvolution results)
deconvResults <- gtools::rdirichlet(n = 20, alpha = c(1, 1, 1, 0.5, 0.1))
colnames(deconvResults) <- paste("CellType", seq(ncol(deconvResults)))
rownames(deconvResults) <- paste("BulkSample", seq(nrow(deconvResults)))
barPlotCellTypes(deconvResults)

# Using a DigitalDLSorter object
DDLS <- DigitalDLSorter(deconv.results = list(Example = deconvResults))
barPlotCellTypes(DDLS)

}
\seealso{
\code{\link{deconvDigitalDLSorter}}
\code{\link{deconvDigitalDLSorterObj}}
}
