% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotations.R
\name{label}
\alias{label}
\title{Non-Overlapping Text Labels}
\source{
This function is modeled after \code{\link[car:pointLabel]{car::pointLabel()}} (originally from the
\pkg{maptools} package).
}
\usage{
label(
  x,
  y = NULL,
  labels = seq_along(x$x),
  type = c("text", "shadow", "box"),
  ...
)
}
\arguments{
\item{x, y}{A \code{\link{numeric}} vector giving the x and y coordinates of a set of
points. If \code{y} is \code{NULL}, an attempt is made to interpret \code{x} in a suitable
way (see \code{\link[grDevices:xy.coords]{grDevices::xy.coords()}}).}

\item{labels}{A \code{\link{character}} vector or \code{\link{expression}} specifying the text
to be written.}

\item{type}{A \code{\link{character}} string specifying the shape of the field.
It must be one of "\code{text}", "\code{shadow}" or "\code{box}". Any unambiguous substring
can be given.}

\item{...}{Further arguments to be passed to \code{\link[graphics:text]{graphics::text()}},
particularly, character expansion, \code{cex} and color, \code{col}.}
}
\value{
\code{label()} is called it for its side-effects: it results in a graphic
being displayed.
}
\description{
Optimize the location of text labels to minimize overplotting text.
}
\seealso{
\code{\link[graphics:text]{graphics::text()}}
}
\author{
N. Frerebeau
}
\concept{annotations}
\keyword{internal}
