% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viz_coordinates.R
\name{prepare_plot}
\alias{prepare_plot}
\title{Prepare Data for Plotting}
\usage{
prepare_plot(
  x,
  margin,
  ...,
  axes = c(1, 2),
  active = TRUE,
  sup = TRUE,
  principal = TRUE,
  extra_quali = NULL,
  extra_quanti = NULL,
  color = NULL,
  fill = FALSE,
  symbol = NULL,
  size = c(1, 6),
  line_type = NULL,
  line_width = size
)
}
\arguments{
\item{x}{A \code{\linkS4class{MultivariateAnalysis}} object.}

\item{margin}{A length-one \code{\link{numeric}} vector giving the subscript
which the data will be returned: \code{1} indicates individuals/rows (the
default), \code{2} indicates variables/columns.}

\item{...}{Further \link[graphics:par]{graphical parameters}.}

\item{axes}{A length-two \code{\link{numeric}} vector giving the dimensions to be
plotted.}

\item{active}{A \code{\link{logical}} scalar: should the active observations be
plotted?}

\item{sup}{A \code{\link{logical}} scalar: should the supplementary observations be
plotted?}

\item{principal}{A \code{\link{logical}} scalar: should principal coordinates be
returned? If \code{FALSE}, standard coordinates are returned.}

\item{extra_quali}{An optional vector of qualitative data for aesthetics
mapping.}

\item{extra_quanti}{An optional vector of quantitative data for aesthetics
mapping. If a single \code{\link{character}} string is passed, it must be one of
"\code{observation}", "\code{mass}", "\code{sum}", "\code{contribution}" or "\code{cos2}"
(see \code{\link[=augment]{augment()}}).}

\item{color}{The colors for lines and points (will be mapped to
\code{extra_quanti} or \code{extra_quali}; if both are set, the latter has priority).
Ignored if set to \code{FALSE}. If \code{NULL}, the default color scheme will be used.}

\item{fill}{The background colors for points (will be mapped to
\code{extra_quanti} or \code{extra_quali}; if both are set, the latter has priority).
Ignored if set to \code{FALSE}.}

\item{symbol}{A vector of plotting characters or symbols (will be mapped to
\code{extra_quali}). This can either be a single character or an integer code for
one of a set of graphics symbols. If \code{symbol} is a named a named vector,
then the symbols will be associated with their name within \code{extra_quali}.
Ignored if set to \code{FALSE}.}

\item{size}{A length-two \code{\link{numeric}} vector giving range of possible sizes
(greater than 0; will be mapped to \code{extra_quanti}).
Ignored if set to \code{FALSE}.}

\item{line_type}{A specification for the line type (will be mapped to
\code{extra_quali}). If \code{line_type} is a named a named vector, then the line
types will be associated with their name within \code{extra_quali}.
Ignored if set to \code{FALSE}.}

\item{line_width}{A specification for the line type and width (will
be mapped to \code{extra_quanti}).
Ignored if set to \code{FALSE}.}
}
\value{
A \code{\link{data.frame}} with the following columns:
\describe{
\item{\code{x}}{Coordinates along x.}
\item{\code{y}}{Coordinates along y.}
\item{\code{extra_quali}}{Extra qualitative variable to be highlighted.}
\item{\code{extra_quanti}}{Extra quantitative variable to be highlighted.}
\item{\code{label}}{Label.}
\item{\code{sup}}{Is supplementary?}
\item{\code{col}}{Color for lines and symbols.}
\item{\code{bg}}{Background color for symbols.}
\item{\code{pch}}{Symbols.}
\item{\code{cex}}{Symbol sizes.}
\item{\code{lty}}{Line types.}
\item{\code{lwd}}{Line widths.}
}
}
\description{
Prepare Data for Plotting
}
\author{
N. Frerebeau
}
\keyword{internal}
