% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors.R
\name{get_year}
\alias{get_year}
\alias{get_quarter}
\alias{get_month}
\alias{get_isoweek}
\alias{get_isoyear}
\title{Get Year, Quarter, Month or Isoweek}
\usage{
get_year(x)

get_quarter(x)

get_month(x)

get_isoweek(x)

get_isoyear(x)
}
\arguments{
\item{x}{a \link{date_xx} or any \R object that can be coerced to \code{POSIXlt}}
}
\value{
an \code{integer} vector.
}
\description{
Get Year, Quarter, Month or Isoweek
}
\details{
If you use \pkg{lubridate} in addition to dint,
you can also use \code{\link[lubridate:year]{lubridate::year()}}, \code{\link[lubridate:month]{lubridate::month()}} and
\code{\link[lubridate:quarter]{lubridate::quarter()}} with dint objects.
}
\examples{
x <- date_yq(2016, 2)
get_year(x)
\dontrun{
library(lubridate)
year(x)
}

x <- date_yq(2016, 2)
get_quarter(x)
\dontrun{
library(lubridate)
quarter(x)
}

x <- date_yq(2016, 2)
get_month(x)
\dontrun{
library(lubridate)
month(x)
}
x <- date_yw(2016, 2)
get_isoweek(x)

get_isoyear(as.Date("2018-01-01"))
get_isoyear(as.Date("2016-01-01"))
}
\seealso{
\code{\link[lubridate:year]{lubridate::year()}},
\code{\link[lubridate:month]{lubridate::month()}},
\code{\link[lubridate:quarter]{lubridate::quarter()}}
}
