% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-syncInputs.R
\name{sync_shiny_inputs}
\alias{sync_shiny_inputs}
\title{Synchronize Shiny Inputs}
\usage{
sync_shiny_inputs(
  input,
  session,
  inputIds,
  uniform = rep("I", length(inputIds)),
  updates,
  snap = 250
)
}
\arguments{
\item{input, session}{shiny reactive objects}

\item{inputIds}{input ids to be synchronized}

\item{uniform}{functions, equaling to length of \code{inputIds}, converting inputs
to a uniform values}

\item{updates}{functions, equaling to length of \code{inputIds}, updating input values}

\item{snap}{numeric, milliseconds to defer the changes}
}
\value{
none.
}
\description{
Synchronize Shiny Inputs
}
\examples{

library(shiny)

ui <- fluidPage(
  textInput('a', 'a', value = 'a'),
  sliderInput('b', 'b', value = 1, min = 0, max = 1000)
)

server <- function(input, output, session) {
  sync_shiny_inputs(input, session, inputIds = c('a', 'b'), uniform = list(
    function(a){as.numeric(a)},
    'I'
  ), updates = list(
    function(a){updateTextInput(session, 'a', value = a)},
    function(b){updateSliderInput(session, 'b', value = b)}
  ))

}

if( interactive() ){
  shinyApp(ui, server)
}

}
