% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{conflict_disbayes}
\alias{conflict_disbayes}
\title{Conflict p-values}
\usage{
conflict_disbayes(x, varname)
}
\arguments{
\item{x}{A fitted \code{\link{disbayes}} model.}

\item{varname}{Either \code{inc}, \code{prev}, \code{mort} or \code{rem}.}
}
\value{
A data frame with columns indicating age, gender and area. 

\code{p1} is a "one-sided" p-value for the null hypothesis that \eqn{r_{obs}=r_{fit}} against 
the alternative that \eqn{r_{obs} > r_{fit}},

\code{p2} is the two-sided p-value for the null hypothesis that \eqn{r_{obs}=r_{fit}} against 
the alternative that \eqn{r_{obs}} is not equal to \eqn{r_{fit}},

where \eqn{r_{obs}} is the rate informed only by direct data, and \eqn{r_{fit}} is the rate
informed by evidence synthesis.  Therefore if the evidence synthesis excludes the 
direct data, then these are interpreted as "conflict" p-values (see Presanis et al. 2013). 

In each case, a small p-value favours the alternative hypothesis.
}
\description{
A test of the hypothesis that the direct data on a disease outcome give the same 
information about that outcome as an indirect evidence synthesis obtained from a fitted \code{\link{disbayes}}
model.   The outcome may be annual incidence, mortality, remission probabilities, 
or prevalence.
}
\details{
Hierarchical models are not currently supported in this function.
}
\references{
Presanis, A. M., Ohlssen, D., Spiegelhalter, D. J. and De Angelis, D. (2013) 
Conflict diagnostics in directed acyclic graphs, with applications in Bayesian evidence 
synthesis. Statistical Science, 28, 376-397.
}
