% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AUC_ordinals.R
\name{prep_ordinal_all}
\alias{prep_ordinal_all}
\title{Shared ordinal x-axis}
\usage{
prep_ordinal_all(dat, x_axis, prob_disc = FALSE)
}
\arguments{
\item{dat}{Discounting data tibble}

\item{x_axis}{Delays/probabilities/social distance variable}

\item{prob_disc}{Boolean for probability discounting, if set to true
function will calculate odrinals based on descending \code{x_axis}
values which would be in line with increasing odds against.}
}
\value{
Tibble that has ordinal values for each \code{x_axis} value
based on all possible \code{x_axis} values.
}
\description{
Helper function to create ordinal values for x-axis variable.
This helper function is designed to be used if the x-axis values
are not identical across every set of indifference points. For example,
if one subject was exposed to delays of 1 day and 1 month and a
second subject was exposed to delays of 1 week and 1 month. In
such a case, \code{prep_ordinal_all()} would return ordinal delays of (1, 3)
for subject 1 and ordinal delays of (2, 3) for subject 2. If 0 exists, will
be coded as 0.
}
\examples{
library(dplyr)

PD <- tibble(
  prob = c(
    c(.05, 1 / 100, 1 / 300, 1 / 750, 1 / 1000, 1 / 3000),
    c(.1, 1 / 100, 1 / 300, 1 / 750, 1 / 1000, 1 / 4000)
  ),
  indiff = c(c(95, 75, 50, 20, 5, 1), c(95, 75, 50, 20, 5, 1) + .25),
  sub = c(rep(1, 6), rep(2, 6))
)

prep_ordinal_all(PD, "prob", prob_disc = TRUE)
}
