% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{dg_search}
\alias{dg_search}
\title{Search}
\usage{
dg_search(query = NULL, order = NULL, status = NULL, category = NULL,
  username = NULL, group = NULL, badge = NULL, in_ = NULL,
  posts_count = NULL, min_age = NULL, max_age = NULL, url = NULL,
  key = NULL, user = NULL, ...)
}
\arguments{
\item{query}{(character) Query terms. Required.}

\item{order}{(character) One of views, latest, likes}

\item{status}{(character) One of open, closed, archived, noreplies, or single_user}

\item{category}{(character) Category to search for}

\item{username}{(character) User name}

\item{group}{(character) Groupo name}

\item{badge}{(character) Badge name}

\item{in_}{(character) One of likes, posted, watching, tracking, private, bookmarks, first}

\item{posts_count}{(integer) Number of posts per topic}

\item{min_age}{(integer) Minimum age}

\item{max_age}{(integer) Maximum age}

\item{url}{Base url for a Discourse installation. See \code{\link{disc_setup}}}

\item{key}{Your api key on the Discourse installation. See \code{\link{disc_setup}}}

\item{user}{Your user name on the Discourse installation. See \code{\link{disc_setup}}}

\item{...}{Named parameters passed on to \code{\link[httr]{GET}},
\code{\link[httr]{POST}}, \code{\link[httr]{PUT}}, or \code{\link[httr]{DELETE}}}
}
\description{
Search
}
\examples{
\dontrun{
dg_search(query = "poo")
dg_search(posts_count = 1)
dg_search(in_ = "posted")
dg_search(status = "open")
}
}

