% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixture.R
\name{rank_contributor_pairs}
\alias{rank_contributor_pairs}
\title{Separate a 2 person mixture}
\usage{
rank_contributor_pairs(contrib_pairs, fit, max_rank = NULL)
}
\arguments{
\item{contrib_pairs}{A \code{contrib_pairs} object obtained from
\code{\link{contributor_pairs}}.}

\item{fit}{A \code{\link{disclapmixfit}} object.}

\item{max_rank}{Not used. Reserved for future use.}
}
\value{
A \code{ranked_contrib_pairs} object that is basically an order
vector and the probabilities for each pair (in the same order as given in
\code{contrib_pairs}), found by using \code{fit}. Note, that contributor
order is disregarded so that each contributor pair is only present once (and
not twice as would be the case if taking order into consideration).
}
\description{
Separate a 2 person mixture by ranking the possible contributor pairs.
}
\examples{

data(danes)
db <- as.matrix(danes[rep(1L:nrow(danes), danes$n), 1L:(ncol(danes) - 1L)])

set.seed(1)
true_contribs <- sample(1L:nrow(db), 2L)
h1 <- db[true_contribs[1L], ]
h2 <- db[true_contribs[2L], ]
db_ref <- db[-true_contribs, ]

h1h2 <- c(paste(h1, collapse = ";"), paste(h2, collapse = ";"))
tab_db <- table(apply(db, 1, paste, collapse = ";"))
tab_db_ref <- table(apply(db_ref, 1, paste, collapse = ";"))
tab_db[h1h2]
tab_db_ref[h1h2]

rm(db) # To avoid use by accident

mixture <- generate_mixture(list(h1, h2))

possible_contributors <- contributor_pairs(mixture)
possible_contributors

fits <- lapply(1L:5L, function(clus) disclapmix(db_ref, clusters = clus))

best_fit_BIC <- fits[[which.min(sapply(fits, function(fit) fit$BIC_marginal))]]
best_fit_BIC

ranked_contributors_BIC <- rank_contributor_pairs(possible_contributors, best_fit_BIC)
ranked_contributors_BIC

plot(ranked_contributors_BIC, top = 10L, type = "b")

get_rank(ranked_contributors_BIC, h1)

}
\seealso{
\code{\link{contributor_pairs}} \code{\link{generate_mixture}}
\code{\link{disclapmix-package}} \code{\link{disclapmix}}
\code{\link{disclapmixfit}} \code{\link{clusterprob}}
\code{\link{predict.disclapmixfit}} \code{\link{print.disclapmixfit}}
\code{\link{summary.disclapmixfit}} \code{\link{simulate.disclapmixfit}}
%\code{\link{haplotype_diversity}}
\code{\link[disclap:disclap-package]{disclap}}
}
\keyword{deconvolution}
\keyword{mixture}
\keyword{separation}
