% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disco.R
\name{percentGenes}
\alias{percentGenes}
\title{Calculates percentage of present genes from a specified superset of expression modules}
\usage{
percentGenes(orthologs, mset = NULL)
}
\arguments{
\item{orthologs}{object of class matchedOrtholog}

\item{mset}{a tmod module set (object of class tmod). If NULL, the default tmod object will be used.}
}
\value{
data frame with columns specifying percentages of genes present in subsequent modules "p_genes" 
and the overall amount of genes in the modules "all_genes"
}
\description{
This function counts the number of genes in modules specified in data.frame created by tmodCERNOtest function 
and returns percentage of those genes which are present in data.frame on the basis of which the enrichment was calculated, 
as well as original number of genes present in the module.
}
\examples{
library(tmod)
data(tmod)
data(orthologs)
disco <- disco.score(orthologs)
ord <- order(disco, decreasing = TRUE)
concordant <- tmodCERNOtest(toupper(orthologs$genes)[ord])
modtable <- percentGenes(orthologs, tmod[concordant$ID])
cbind(concordant, modtable)
}
