% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryNet.R
\name{summaryNet}
\alias{summaryNet}
\title{Print summary of graph results}
\usage{
summaryNet(
  netintconfigData = NULL,
  coreNetAnalysisData = NULL,
  subgroupsNetAnalysisData = NULL,
  display = FALSE
)
}
\arguments{
\item{netintconfigData}{Data object where the graph configuration data is stored (from `prepareGraphs`)}

\item{coreNetAnalysisData}{Data object where the core analysis data is stored (from `coreNetAnalysis`)}

\item{subgroupsNetAnalysisData}{Data object where subgroup analysis data is stored (from `subgroupsNetAnalysis`)}

\item{display}{Should the output be displayed in the R console?
Results are saved as the project name in the initial config data as a text file on disk.}
}
\value{
Prints organized summary of all results of the graph with modular components on console or to .txt file on disk.
}
\description{
Returns a summary of the processed graph results on console. The initial graph configuration and core analysis is required for this function to work. The other components are optional due to the modular nature of the functions. Data must be stored as a data object.
}
\examples{
df <- sampleData1
prepNet <- tabulate_edges(df, iscsvfile = FALSE, silentNodes = 0)
prepGraphs <- prepareGraphs(prepNet, project_title = "Sample Data 1", weightedGraph = TRUE)
coreNet <- coreNetAnalysis(prepGraphs)
subgroup <- subgroupsNetAnalysis(prepGraphs, raw_input = df)
summaryNet(netintconfigData = prepGraphs, coreNetAnalysisData = coreNet,
subgroupsNetAnalysisData = subgroup, display = TRUE)

}
