% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_acp_utils.R
\name{e_pcaind_3D}
\alias{e_pcaind_3D}
\title{PCA plot of individuals in 3D}
\usage{
e_pcaind_3D(
  modelo,
  axes = c(1, 2, 3),
  colorInd = "steelblue",
  cos2 = 0,
  colorCos = "firebrick",
  titulos = c("Bien Representados", "Mal Representados")
)
}
\arguments{
\item{modelo}{an object of class PCA [FactoMineR].}

\item{axes}{a numeric vector of length 3 specifying the dimensions to be plotted.}

\item{colorInd}{a color for the individuals well represented.}

\item{cos2}{a numeric value from 0 to 1 specifying the quality of the individuals.}

\item{colorCos}{a color for individuals badly represented.}

\item{titulos}{a character vector of length 2 specifying the titles to use on legend.}
}
\value{
echarts4r plot
}
\description{
PCA plot of individuals in 3D
}
\examples{
p <- discoveR:::PCA(iris[, -5], graph = FALSE)
e_pcaind_3D(p)

}
\author{
Diego Jimenez <diego.jimenez@promidat.com>
}
