% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/discreteRV-Simulations.r
\name{props}
\alias{props}
\title{Proportions of observed outcomes in one or more vectors of simulated trials}
\usage{
props(...)
}
\arguments{
\item{...}{Simulation data produced with the 'rsim()' function}
}
\description{
Proportions of observed outcomes in one or more vectors of simulated trials
}
\examples{
X.Bern <- make.RV(c(1,0), c(.5,.5))
X.Bern.sim100 <- rsim(100, X.Bern)

X.loaded.die <- make.RV(1:6, odds = c(1,1,1,1,2,4))
X.loaded.die.sim100 <- rsim(100, X.loaded.die)
props(X.Bern.sim100)
props(X.loaded.die.sim100)
# Note: 'props()' is the analog of 'probs()', but
#       'props()' applies to SIMULATION DATA and tabulates them, whereas
#       'probs()' applies to RANDOM VARIABLES and lists their probabilities.
#       By the LLN the results of 'props()' will be close to 'probs()' for
#       for large simulations.
}

