% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/market_model.R
\name{plot,market_model,ANY-method}
\alias{plot,market_model,ANY-method}
\title{Plots the model.}
\usage{
\S4method{plot}{market_model,ANY}(x)
}
\arguments{
\item{x}{A model object.}
}
\description{
Displays a graphical illustration of the passed model object.
}
\examples{
\donttest{
model <- simulate_model(
  "diseq_basic", list(
    # observed entities, observed time points
    nobs = 500, tobs = 3,
    # demand coefficients
    alpha_d = -0.9, beta_d0 = 8.9, beta_d = c(0.3, -0.2), eta_d = c(-0.03, -0.01),
    # supply coefficients
    alpha_s = 0.9, beta_s0 = 4.2, beta_s = c(0.03), eta_s = c(0.05, 0.02)
  ),
  seed = 44
)

# show model's illustration plot
plot(model)
}
}
