% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/char.diff.R
\name{char.diff}
\alias{char.diff}
\title{Character differences}
\usage{
char.diff(matrix)
}
\arguments{
\item{matrix}{A discrete matrix or a list containing discrete characters.}
}
\value{
A character difference value or a matrix of class \code{char.diff}
}
\description{
Calculates the character difference from a discrete matrix
}
\details{
The character difference is calculated as half the sum of the Gower distances between the characters.
}
\examples{
## Comparing two characters
char.diff(list(c(0, 1, 0, 1), c(0, 1, 1, 1)))

## Pairwise comparisons in a morphological matrix
morpho_matrix <- matrix(sample(c(0,1), 100, replace = TRUE), 10)
char.diff(morpho_matrix)

}
\references{
Gower, J.C. 1966. Some distance properties of latent root and vector methods used in multivariate analysis. Biometrika 53:325-338.
}
\seealso{
\code{\link{plot.char.diff}}.
}
\author{
Thomas Guillerme
}
