% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dispRity.utilities.R
\name{combine.subsets}
\alias{combine.subsets}
\title{Combines or cleans subsets.}
\usage{
combine.subsets(data, subsets)
}
\arguments{
\item{data}{A \code{dispRity} object.}

\item{subsets}{Either a \code{vector} of the number or name of the subsets to merge or a single \code{numeric} value of the minimum of elements for each series (see details).}
}
\value{
A \code{dispRity} object containing the original matrix and subsets.
NOTE: if the data are already bootstrapped/rarefied or/and disparity already calculated the operation will have to be performed again.
}
\description{
Combines multiple subsets together or cleans a subset series to contain at least n elements.
}
\details{
If \code{subset} is a vector, the subsets are merged in the given input order. \code{c(1, 3, 4)} will merge subsets 1 and 3 into 4, while the opposite, \code{c(3, 4, 1)} will merge subsets 3 and 4 into 1.
When a single numeric value is given, subsets are merged with the next subset until the correct number of elements for each subset is reached (apart from the last subset that gets merged with the previous one).
}
\examples{
## Generate subsets from a dummy matrix
dummy_matrix <- matrix(rnorm(120), 40)
dummy_subsets <- custom.subsets(dummy_matrix,
     group = list("a" = c(1:5), "b" = c(6:10), "c" = c(11:20),
                  "d" = c(21:24), "e" = c(25:30), "f" = c(31:40)))

## Merging the two first subsets
combine.subsets(dummy_subsets, c(1,2))

## Merging the three subsets by name
combine.subsets(dummy_subsets, c("d", "c", "e"))

## Merging the subsets to contain at least 20 taxa
combine.subsets(dummy_subsets, 10)

}
\seealso{
\code{\link{custom.subsets}}, \code{\link{chrono.subsets}}, \code{\link{boot.matrix}}, \code{\link{dispRity}}.
}
\author{
Thomas Guillerme
}
