## Getting polymorphosim function (internal for read.nexus.data)
get.polymorphism <- function (x) {
    ## Detect polymorphism function
    is.poly.start <- function(x) {return("(" == x || "{" == x)}
    is.poly.end   <- function(x) {return(")" == x || "}" == x)}
    ## Position increment
    position <- 1
    ## Check which position contains a polymorphism
    while(position <= length(x)) {
        ## Check whether the position is polymorphic
        if(is.poly.start(x[position])){
            ## Find the polymorphism end
            poly_end <- position + 1
            while(!is.poly.end(x[poly_end])) {
                poly_end <- poly_end + 1
                if(is.poly.start(x[poly_end]) || poly_end > length(x)) {
                    stop("missing closing bracket for a polymorphism at position ", position)
                }
            }
            ## Replace the position by what's in the middle of the polymorphism
            x[position] <- paste0(x[(position+1):(poly_end-1)], collapse = "/")
            ## Remove the polymorphism
            x <- x[-c((position+1):poly_end)]
        }
        ## Increment the position
        position <- position + 1
    }
    return(x)
}

## Update read.nexus.data (temporary)
read.nexus.poly <- ape::read.nexus.data
body(read.nexus.poly)[[18]][[4]][[11]][[3]][[2]] <- body(read.nexus.poly)[[18]][[4]][[11]][[4]][[3]] <- substitute(tsp <- get.polymorphism(strsplit(Seq, NULL)[[1]]))

## Converting a list of characters (ape format) into the Claddis format
convert.to.Claddis <- function(data) {
    output <- list()
    
    ## Topper
    output$Topper$Head <- "List generated by dispRity::Claddis.ordination"

    ## Matrix_1
    output$Matrix_1$BlockName <- NA
    output$Matrix_1$Datatype <- "STANDARD"
    output$Matrix_1$Matrix <- do.call(rbind, data)
    output$Matrix_1$Ordering <- rep("unord", length(data[[1]]))
    output$Matrix_1$Weights <- rep(1, length(data[[1]]))
    op <- options(warn = -1)
    output$Matrix_1$MinVals <- unlist(apply(output$Matrix_1$Matrix, 2, function(x) min(as.numeric(x), na.rm = TRUE)))
    is_nas <- is.na(output$Matrix_1$MinVals)
    output$Matrix_1$MaxVals <- unlist(apply(output$Matrix_1$Matrix, 2, function(x) max(as.numeric(x), na.rm = TRUE)))
    output$Matrix_1$Characters$Symbols <- unique(as.numeric(unlist(data)[-which(is.na(unlist(data)))]))
    op <- options(warn = 0)
    output$Matrix_1$Characters$Missing <- "?"
    output$Matrix_1$Characters$Gap <- "-"

    ## Transform the missing data into "?"
    output$Matrix_1$Matrix <- ifelse(output$Matrix_1$Matrix == "?", NA, output$Matrix_1$Matrix)
    ## Transform the inapplicables in ""
    output$Matrix_1$Matrix <- ifelse(output$Matrix_1$Matrix == "-", "", output$Matrix_1$Matrix)

    return(output)
}
