% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.metric.R
\name{test.metric}
\alias{test.metric}
\title{Test disparity metric}
\usage{
test.metric(
  data,
  metric,
  ...,
  shifts,
  shift.options,
  model,
  replicates = 3,
  steps = 10,
  dimensions,
  verbose = FALSE,
  save.steps = FALSE
)
}
\arguments{
\item{data}{A matrix or a \code{dispRity} object (see details).}

\item{metric}{A vector containing one to three functions. At least of must be a dimension-level 1 or 2 function (see details). If \code{data} is a \code{dispRity} object with disparity already calculated, this argument can be left empty (and the one from \code{data} is recycled)}

\item{...}{Optional arguments to be passed to the metric.}

\item{shifts}{The types of shits to test, can be \code{"random"}, \code{"size"}, \code{"density"}, \code{"evenness"} and \code{"position"}. See details.}

\item{shift.options}{Optional, a \code{list} of named arguments to be passed to \code{\link{reduce.space}}}

\item{model}{Optional, which model to fit for testing the metric. See details.}

\item{replicates}{A \code{numeric} number of replicates to increase variance. By default \code{replicates = 3}. If \code{replicates = 1}, the \code{model} is not run.}

\item{steps}{The number of steps in the space reduction to output between 10\% and 100\%. By default \code{steps = 10}.}

\item{dimensions}{Optional, a \code{numeric} value or proportion of the dimensions to keep.}

\item{verbose}{A \code{logical} value indicating whether to be verbose (\code{TRUE}) or not (\code{FALSE}; default).}

\item{save.steps}{A \code{logical} value indicating whether to save the data for visualising the the shift steps if plotting the results (\code{TRUE}) or not (\code{FALSE}; default).}
}
\value{
This function outputs a \code{dispRity} object containing a list of simulated reductions in trait space. The results can be accessed through the usual S3 methods (\code{print}, \code{summary}, \code{plot}) or accessed directly through \code{x$<name_of_the_shift>} (e.g. \code{x$random} for the random shift results).
}
\description{
Test whether a metric captures changes trait space size, density and position.
}
\details{
For the three non-random shifts: \code{"size"}, \code{"density"}, \code{"evenness"} and \code{"position"}, the function returns both of shifts as:
\itemize{
     \item \code{"size.inner"} and \code{"size.outer"} removing data from the edges or the centre respectively (contracting the size and "hollowing" it respectively).
     \item \code{"density.higher"} and \code{"density.lower"} removing data to increase or decrease density respectively (increasing/decreasing nearest neighbour distance).
     \item \code{"evenness.flattened"} and \code{"evenness.compacted"} removing data to from the centre of the distribution or from the edges to resepectively "flatten" or "condense" the distribution.
     \item \code{"position.top"} and \code{"position.bottom"} removing data from one side or the other of the space (the sides are selected from the point with lowest/highest scores on each dimensions respectively).
}
See figure 2 in Guillerme et al. 2020 for more details.

The default \code{model} is a linear model using the following function:
    \code{model = function(data) lm(disparity ~ reduction, data)}
You can provide your own as long as it is a single function with \code{data} as a single argument. The two terms from data should be called \code{reduction} for the variable on the x axis and \code{disparity} for the variable on the y axis. For example:
    \code{model = function(data) nls(disparity ~ a*reduction/(b+reduction), data)}
Note that models (like this example) should be specific to the dataset. Any type of model can be fitted but only the ones with an associated \code{summary} function will be correctly displayed by \code{\link{summary.dispRity}}.
To not run any model, use \code{model = NULL}.
}
\examples{
## Creating a 2D uniform space
space <- space.maker(300, 2, runif)

## A simple test with only 1 replicate for two shifts (random and size):
simple_test <- test.metric(space, metric = c(prod, ranges),
                           replicates = 1, shifts = c("random", "size")) 

## Summarising the tests
summary(simple_test)

## Visualising the test
plot(simple_test)

## Applying the test directly on a disparity object
data(disparity)
median_centroid_test <- test.metric(disparity, shifts = "size")

## Summarising the tests
summary(median_centroid_test)

## Visualising the test
plot(median_centroid_test)

\dontrun{
## Note that the tests can take several minutes to run.

## Testing the sum of variance on all shifts 
sum_var_test <- test.metric(space, metric = c(sum, variances),
                            shifts = c("random", "size", "density", "position"))

## Summarising the tests
summary(sum_var_test)

## Visualising the test
plot(sum_var_test)

## Creating a 2D uniform space
space <- space.maker(300, 2, runif)

## Re-running the test on two shifts with data saving for visualisation
median_centroid_test <- test.metric(space,
                                    metric = c(median, centroids),
                                    shifts = c("random", "size"),
                                    save.steps = TRUE)

## Visualising the tests results and display the shifts visualisation
plot(median_centroid_test)
}
 
}
\references{
Guillerme T, Puttick MN, Marcy AE, Weisbecker V. \bold{2020} Shifting spaces: Which disparity or dissimilarity measurement best summarize occupancy in multidimensional spaces?. Ecol Evol. 2020;00:1-16. (doi:10.1002/ece3.6452)
}
\seealso{
\code{\link{reduce.space}} \code{\link{dispRity}} \code{\link{plot.dispRity}}
}
\author{
Thomas Guillerme
}
