% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/portfolio_compute.R
\name{portfolio_compute}
\alias{portfolio_compute}
\title{Portfolio Compute}
\usage{
portfolio_compute(
  portfolio_transactions,
  market_prices,
  method = "count",
  allow_short = TRUE,
  time_threshold = "0 mins",
  exact_market_prices = TRUE,
  portfolio_driven_DE = FALSE,
  time_series_DE = FALSE,
  assets_time_series_DE = NULL,
  verbose = c(0, 0),
  progress = FALSE
)
}
\arguments{
\item{portfolio_transactions}{Data frame. The investor's transactions data frame.}

\item{market_prices}{Data frame containing the market prices.}

\item{method}{Character string containing the method to use to compute
realized and paper gains and losses. If "none" nothing is computed but the
investor's portfolio updates. Otherwise it has to be one of "count" (default),
"total", "value", "duration", or "all".}

\item{allow_short}{Logical. If TRUE short positions are allowed, otherwise only
long positions are allowed.}

\item{time_threshold}{Character in the format "value units" indicating the
time threshold at which the computed financial difftime has to be evaluated
(for instance "05 mins" or "20 hours").
The allowed units are "secs", "mins", "hours", "days" and "weeks"
(See \code{base::\link[base:difftime]{difftime}}).}

\item{exact_market_prices}{Logical. If TRUE then \code{\link{closest_market_price}}
uses exact datetime match to look for the closest price of each asset.
It usually speeds up computation by a small degree, but it requires the
\code{market_prices} to have the prices for each transaction asset along each
transaction datetimes.}

\item{portfolio_driven_DE}{Logical. If TRUE the realized and paper gains and
losses for the positive (that is when the investor's portfolio value, as
computed through \code{\link{evaluate_portfolio}}, is greater than zero)
and the negative (that is when the investor's portfolio value, as computed
through \code{\link{evaluate_portfolio}}, is smaller than zero) portfolios
are returned.}

\item{time_series_DE}{Logical. If TRUE the time series of disposition effect
is computed on 'count' and 'value' methods only.}

\item{assets_time_series_DE}{Character vector of assets' names as contained
into \code{portfolio_transactions} on which to compute the time series disposition
effect.}

\item{verbose}{Numeric or logical vector of length 2 that allows to control
for the function's verbosity.}

\item{progress}{Logical. If TRUE a progress bar is displayed.}
}
\value{
A data frame containing the investor's
portfolio and the values of realized and paper gains and losses
computed by means of the chosen method on each portfolio assets.

If time_series_DE is set to TRUE, then also time series disposition effect
results are returned.
}
\description{
Computation of all the transaction updates and the
realized and paper gains and losses for each assets.
}
\seealso{
\code{\link{realized_compute}}, \code{\link{paper_compute}},
\code{\link{gains_losses}}
}
