% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{dip2}
\alias{dip2}
\title{Dissolution data of one reference batch and five test batches}
\format{
A data frame with 72 observations and 8 variables:
\describe{
  \item{type}{Factor with levels \code{Reference} and \code{Test}}
  \item{tablet}{Factor with levels \code{1} to \code{12} representing
    individual tablets}
  \item{batch}{Factor with levels \code{b0}, \code{b1}, \code{b2}, \code{b3},
    \code{b4} and \code{b5}}
  \item{t.0}{Numeric of the \% release at the initial testing point}
  \item{t.30}{Numeric of the \% release at the 30 minutes testing point}
  \item{t.60}{Numeric of the \% release at the 60 minutes testing point}
  \item{t.90}{Numeric of the \% release at the 90 minutes testing point}
  \item{t.180}{Numeric of the \% release at the 180 minutes testing point}
}
}
\source{
See reference: Example data set shown in Table 4.
}
\usage{
data(dip2)
}
\description{
A data set containing the dissolution data of one reference batch and five
  test batches of \eqn{n = 12} tablets each, i.e. the dissolution profiles
  of the \% drug release observed within a period of 180 minutes.
}
\examples{
str(dip2)
}
\references{
Shah, V. P., Tsong, Y., Sathe, P., and Liu, J. P. \emph{In vitro} dissolution
profile comparison - statistics and analysis of the similarity factor,
\eqn{f_2}. \emph{Pharm Res}. 1998; \strong{15}(6): 889-896.\cr
\doi{10.1023/A:1011976615750}
}
\keyword{datasets}
