% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate.mean.detection.prob.R
\name{calculate.mean.detection.prob}
\alias{calculate.mean.detection.prob}
\title{Mean detection probability.}
\usage{
calculate.mean.detection.prob(theta = theta, w, detection.function)
}
\arguments{
\item{theta}{The detection function parameters. A single value for halfnormal, or a vector of two values for hazard rate.}

\item{w}{The maximum range of observation. Objects at distance greater than w from the observer are assumed to never be recorded.}

\item{detection.function}{The detection function. Only "halfnormal" and "hazard" (hazard rate) are supported at present.}
}
\value{
The mean detection probability over the distance range [0,w].
}
\description{
Calculates the mean detection probability over the range of observation.
}
\examples{
calculate.mean.detection.prob(detection.function="hazard",theta=c(0.448,2),w=1) # should be 0.6
}
\references{
Buckland S, Anderson D, Burnham K, Laake J and Borchers D (2001). Introduction to Distance Sampling: Estimating Abundance of Biological Populations. Oxford: Oxford University Press.

Clark, R. G. (2016), "Statistical efficiency in distance sampling," PLoS One, forthcoming, www.plosone.org
}

