% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{auto_sum_full_cpp}
\alias{auto_sum_full_cpp}
\title{(C++) Sum Distances Between All Consecutive Samples in Two Time Series}
\usage{
auto_sum_full_cpp(x, y, distance = "euclidean")
}
\arguments{
\item{x}{(required, numeric matrix) univariate or multivariate time series.}

\item{y}{(required, numeric matrix) univariate or multivariate time series
with the same number of columns as 'x'.}

\item{distance}{(optional, character string) distance name from the "names"
column of the dataset \code{distances} (see \code{distances$name}). Default: "euclidean"}
}
\value{
numeric
}
\description{
Computes the cumulative auto sum of autodistances of two time series.
The output value is used as normalization factor when computing dissimilarity scores.
}
\examples{
#simulate two time series
x <- zoo_simulate(seed = 1)
y <- zoo_simulate(seed = 2)

#auto sum
auto_sum_full_cpp(
  x = x,
  y = y,
  distance = "euclidean"
)
}
\seealso{
Other Rcpp_auto_sum: 
\code{\link{auto_distance_cpp}()},
\code{\link{auto_sum_cpp}()},
\code{\link{auto_sum_path_cpp}()},
\code{\link{subset_matrix_by_rows_cpp}()}
}
\concept{Rcpp_auto_sum}
