% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsl_colnames.R
\name{tsl_colnames_set}
\alias{tsl_colnames_set}
\title{Set Column Names in Time Series Lists}
\usage{
tsl_colnames_set(tsl = NULL, names = NULL)
}
\arguments{
\item{tsl}{(required, list) Time series list. Default: NULL}

\item{names}{(required, list or character vector):
\itemize{
\item list: with same names as 'tsl', containing a vector of new column names for each time series in 'tsl'.
\item character vector: vector of new column names assigned by position.
}}
}
\value{
time series list
}
\description{
Set Column Names in Time Series Lists
}
\examples{
tsl <- tsl_simulate(
  cols = 3
  )

tsl_colnames_get(
  tsl = tsl
  )

#using a vector
#extra names are ignored
tsl <- tsl_colnames_set(
  tsl = tsl,
  names = c("x", "y", "z", "zz")
)

tsl_colnames_get(
  tsl = tsl
)

#using a list
#extra names are ignored too
tsl <- tsl_colnames_set(
  tsl = tsl,
  names = list(
    A = c("A", "B", "C"),
    B = c("X", "Y", "Z", "ZZ")
  )
)

tsl_colnames_get(
  tsl = tsl
)
}
\seealso{
Other tsl_management: 
\code{\link{tsl_burst}()},
\code{\link{tsl_colnames_clean}()},
\code{\link{tsl_colnames_get}()},
\code{\link{tsl_colnames_prefix}()},
\code{\link{tsl_colnames_suffix}()},
\code{\link{tsl_count_NA}()},
\code{\link{tsl_diagnose}()},
\code{\link{tsl_handle_NA}()},
\code{\link{tsl_join}()},
\code{\link{tsl_names_clean}()},
\code{\link{tsl_names_get}()},
\code{\link{tsl_names_set}()},
\code{\link{tsl_names_test}()},
\code{\link{tsl_ncol}()},
\code{\link{tsl_nrow}()},
\code{\link{tsl_repair}()},
\code{\link{tsl_subset}()},
\code{\link{tsl_time}()},
\code{\link{tsl_to_df}()}
}
\concept{tsl_management}
