% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_matrix_guide.R
\name{utils_matrix_guide}
\alias{utils_matrix_guide}
\title{Color Guide for Matrix Plot}
\usage{
utils_matrix_guide(
  m = NULL,
  matrix_color = NULL,
  breaks = NULL,
  title = NULL,
  text_cex = 1
)
}
\arguments{
\item{m}{(required, numeric matrix) distance or cost matrix generated by \code{\link[=psi_distance_matrix]{psi_distance_matrix()}} or \code{\link[=psi_cost_matrix]{psi_cost_matrix()}}, but any numeric matrix will work. Default: NULL}

\item{matrix_color}{(optional, character vector) vector of colors. Default: NULL}

\item{breaks}{(optional, numeric vector) vector of breaks for the color guide. Default: NULL}

\item{title}{(optional, character string) guide title. Default: NULL}

\item{text_cex}{(optional, numeric) multiplier for the text size. Default: 1}
}
\value{
Plot
}
\description{
Plots a color legend for a distance or cost matrix for multi-panel plots or external image editors.
}
\examples{
#prepare time series list
tsl <- tsl_simulate(
  n = 2,
  independent = TRUE
)

#distance matrix between time series
dm <- psi_distance_matrix(
  x = tsl[[1]],
  y = tsl[[2]]
)

if(interactive()){
  utils_matrix_guide(m = dm)
}
}
\seealso{
Other internal_plotting: 
\code{\link{color_continuous}()},
\code{\link{color_discrete}()},
\code{\link{utils_color_breaks}()},
\code{\link{utils_line_color}()},
\code{\link{utils_line_guide}()},
\code{\link{utils_matrix_plot}()}
}
\concept{internal_plotting}
