% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_optimize_spline.R
\name{utils_optimize_spline}
\alias{utils_optimize_spline}
\title{Optimize Spline Models for Time Series Resampling}
\usage{
utils_optimize_spline(x = NULL, y = NULL, max_complexity = FALSE)
}
\arguments{
\item{x}{(required, numeric vector) predictor, a time vector coerced to numeric. Default: NULL}

\item{y}{(required, numeric vector) response, a column of a zoo object. Default: NULL}

\item{max_complexity}{(required, logical). If TRUE, RMSE optimization is ignored, and the model of maximum complexity is returned. Default: FALSE}
}
\value{
Object of class "smooth.spline".
}
\description{
Internal function used in \code{\link[=zoo_resample]{zoo_resample()}}. It finds optimal \code{df} parameter of a smoothing spline model \code{y ~ x} fitted with \code{\link[stats:smooth.spline]{stats::smooth.spline()}}  that minimizes the root mean squared error (rmse) between observations and predictions, and returns a model fitted with such \code{df}.
}
\examples{

#zoo time series
xy <- zoo_simulate(
  cols = 1,
  rows = 30
)

#optimize splines model
m <- utils_optimize_spline(
  x = as.numeric(zoo::index(xy)), #predictor
  y = xy[, 1] #response
)

print(m)

#plot observation
plot(
  x = zoo::index(xy),
  y = xy[, 1],
  col = "forestgreen",
  type = "l",
  lwd = 2
  )

#plot prediction
points(
  x = zoo::index(xy),
  y = stats::predict(
    object = m,
    x = as.numeric(zoo::index(xy))
  )$y,
  col = "red"
)

}
\seealso{
Other tsl_processing_internal: 
\code{\link{utils_drop_geometry}()},
\code{\link{utils_global_scaling_params}()},
\code{\link{utils_optimize_loess}()},
\code{\link{utils_rescale_vector}()}
}
\concept{tsl_processing_internal}
