% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_line_guide.R
\name{utils_line_guide}
\alias{utils_line_guide}
\title{Guide for Time Series Plots}
\usage{
utils_line_guide(
  x = NULL,
  position = "topright",
  line_color = NULL,
  line_width = 1,
  length = 1,
  text_cex = 0.7,
  guide_columns = 1,
  subpanel = FALSE
)
}
\arguments{
\item{x}{(required, sequence) a zoo time series or a time series list. Default: NULL}

\item{position}{(optional, vector of xy coordinates or character string). This is a condensed version of the \code{x} and \code{y} arguments of the \code{\link[graphics:legend]{graphics::legend()}} function. Coordinates (in the range 0 1) or keyword to position the legend. Accepted keywords are: "bottomright", "bottom", "bottomleft", "left", "topleft", "top", "topright", "right" and "center". Default: "topright".}

\item{line_color}{(optional, character vector) vector of colors for the time series columns. If NULL, uses the palette "Zissou 1" provided by the function \code{\link[grDevices:palettes]{grDevices::hcl.colors()}}. Default: NULL}

\item{line_width}{(optional, numeric vector) Widths of the time series lines. Default: 1}

\item{length}{(optional, numeric) maps to the argument \code{seg.len} of \code{\link[graphics:legend]{graphics::legend()}}. Length of the lines drawn in the legend. Default: 1}

\item{text_cex}{(optional, numeric) Multiplier of the text size. Default: 0.7}

\item{guide_columns}{(optional, integer) Number of columns in which to set the legend items. Default: 1.}

\item{subpanel}{(optional, logical) internal argument used when generating the multipanel plot produced by \code{\link[=distantia_dtw_plot]{distantia_dtw_plot()}}.}
}
\value{
plot
}
\description{
Guide for Time Series Plots
}
\examples{
x <- zoo_simulate()

if(interactive()){

  zoo_plot(x, guide = FALSE)

  utils_line_guide(
    x = x,
    position = "right"
  )

}

}
\seealso{
Other internal_plotting: 
\code{\link{color_continuous}()},
\code{\link{color_discrete}()},
\code{\link{utils_color_breaks}()},
\code{\link{utils_line_color}()},
\code{\link{utils_matrix_guide}()},
\code{\link{utils_matrix_plot}()}
}
\concept{internal_plotting}
