% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coxstuff.R
\name{CoxMaster}
\alias{CoxMaster}
\title{Create a master object to control \code{CoxWorker} worker objects}
\description{
\code{CoxMaster} objects instantiate and run a distributed Cox model
computation fit
}
\seealso{
\code{CoxWorker} which generates objects matched to such a master object
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{CoxMaster$new()}}
\item \href{#method-kosher}{\code{CoxMaster$kosher()}}
\item \href{#method-logLik}{\code{CoxMaster$logLik()}}
\item \href{#method-addSite}{\code{CoxMaster$addSite()}}
\item \href{#method-run}{\code{CoxMaster$run()}}
\item \href{#method-summary}{\code{CoxMaster$summary()}}
\item \href{#method-clone}{\code{CoxMaster$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\subsection{Method \code{new()}}{
\code{CoxMaster} objects instantiate and run a distributed Cox model
computation fit
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CoxMaster$new(defn, debug = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{defn}}{a computation definition}

\item{\code{debug}}{a flag for debugging, default \code{FALSE}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
R6 \code{CoxMaster} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-kosher"></a>}}
\subsection{Method \code{kosher()}}{
Check if inputs and state of object are sane. For future use
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CoxMaster$kosher()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{TRUE} or \code{FALSE}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-logLik"></a>}}
\subsection{Method \code{logLik()}}{
Return the partial log likelihood on all data for given \code{beta} parameter.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CoxMaster$logLik(beta)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{beta}}{the parameter vector}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a named list with three components: \code{value} contains the value of the
log likelihood, \code{gradient} contains the score vector, and \code{hessian} contains
the estimated hessian matrix
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-addSite"></a>}}
\subsection{Method \code{addSite()}}{
Add a url or worker object for a site for participating in the distributed computation. The worker object can be used to avoid complications in debugging remote calls during prototyping.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CoxMaster$addSite(name, url = NULL, worker = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{of the site}

\item{\code{url}}{web url of the site; exactly one of \code{url} or \code{worker} should be specified}

\item{\code{worker}}{worker object for the site; exactly one of \code{url} or \code{worker} should be specified}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-run"></a>}}
\subsection{Method \code{run()}}{
Run the distributed Cox model fit and return the estimates
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CoxMaster$run(control = coxph.control())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{control}}{parameters, same as \code{survival::coxph.control()}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a named list of \code{beta}, \code{var}, \code{gradient}, \code{iter}, and \code{returnCode}
#' @description ' Return the summary of fit as a data frame
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-summary"></a>}}
\subsection{Method \code{summary()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CoxMaster$summary()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
a summary data frame columns for \code{coef},
\code{exp(coef)}, ' standard error, z-score, and p-value for each
parameter in the model following the same format as the
\code{survival} package
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CoxMaster$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
