% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SetInterval.R
\name{liesInSetInterval}
\alias{liesInSetInterval}
\title{Test if Data Lies in SetInterval.}
\arguments{
\item{x}{vector of numerics to test.}

\item{all}{logical, see details.}

\item{bound}{logical, if FALSE (default) tests against dmin/dmax otherwise inf/sup.}
}
\value{
Either a vector of logicals if \code{all} is FALSE otherwise returns TRUE if every element
lies in the SetInterval or FALSE otherwise.
}
\description{
Tests if the given data lies in the SetInterval, either tests if all data lies in the type
or any of it, can choose if bounds should be included.
}
\details{
If \code{all} is TRUE (default) returns TRUE only if every element in x lies in the type. If \code{all}
is FALSE then returns a vector of logicals for each corresponding element in the vector x.

If called on a set, then the \code{bound} argument is ignored and returns TRUE if x is an element
in the set.

This is an R6 method only, no S3 dispatch is available.
}
\section{R6 Usage}{
 $liesInSetInterval(x, all = FALSE, bound = FALSE)
}

\seealso{
\code{\link{SetInterval}}
}
