% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DistributionDecorator_CoreStatistics.R
\name{CoreStatistics}
\alias{CoreStatistics}
\title{Core Statistical Methods for Distributions}
\value{
Returns a decorated R6 object inheriting from class SDistribution with the methods listed below
added to the SDistribution methods.
}
\description{
This decorator adds numeric methods for missing analytic expression in distr6 Distribution
objects as well as adding generalised expectation and moments functions.
}
\details{
Decorator objects add functionality to the given Distribution object by copying methods
in the decorator environment to the chosen Distribution environment. See the 'Added Methods' section
below to find details of the methods that are added to the Distribution. Methods already
present in the distribution are not overwritten by the decorator.

Use \code{\link{decorate}} to decorate a Distribution.

All methods in this decorator use numerical approximations and therefore better results may be available
from analytic computations.
}
\section{Constructor}{
 CoreStatistics$new(distribution)
}

\section{Constructor Arguments}{

\tabular{lll}{
\strong{Argument} \tab \strong{Type} \tab \strong{Details} \cr
\code{distribution} \tab distribution \tab Distribution to decorate. \cr
}
}

\section{Added Methods}{

\tabular{lll}{
\strong{Method} \tab \strong{Name} \tab \strong{Link} \cr
\code{mgf(t)} \tab Moment generating function \tab \code{\link{mgf}} \cr
\code{pgf(t)} \tab Probability generating function \tab \code{\link{pgf}} \cr
\code{cf(t)} \tab Characteristic function \tab \code{\link{cf}} \cr
\code{entropy(base = 2)} \tab (Shannon) Entropy \tab \code{\link{entropy}} \cr
\code{skewness()} \tab Skewness \tab \code{\link{skewness}} \cr
\code{kurtosis(excess = TRUE)} \tab Kurtosis \tab \code{\link{kurtosis}} \cr
\code{kthmoment(type = "central")} \tab Kth Moment \tab \code{\link{kthmoment}} \cr
\code{genExp(trafo)} \tab Generalised Expectation \tab \code{\link{genExp}} \cr
\code{mode(which = "all")} \tab Mode \tab \code{\link{mode}} \cr
\code{variance()} \tab Variance \tab \code{\link{variance}} \cr
\code{mean()} \tab Arithmetic mean \tab \code{\link{mean.Distribution}} \cr
}
}

\examples{
x = Binomial$new()
decorate(x, CoreStatistics)
x$genExp()

x = Binomial$new(decorators = CoreStatistics)
x$kthmoment(4)

}
\seealso{
\code{\link{decorate}}, \code{\link{listDecorators}}
}
