% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Wrapper_Convolution.R
\name{Convolution}
\alias{Convolution}
\title{Distribution Convolution Wrapper}
\value{
Returns an R6 object of class Convolution.
}
\description{
Calculates the convolution of two distribution via numerical calculations.
}
\details{
The convolution of two probability distributions \eqn{X}, \eqn{Y} is the sum
\deqn{Z = X + Y}
which has a pmf,
\deqn{P(Z = z) = \sum_x P(X = x)P(Y = z - x)}
with an integration analogue for continuous distributions.

Currently distr6 supports the addition of discrete and continuous probability distributions, but only
subtraction of continuous distributions.
}
\section{Constructor}{
 Convolution$new(dist1, dist2, add = TRUE, type = NULL)
}

\section{Constructor Arguments}{

\tabular{lll}{
\strong{Argument} \tab \strong{Type} \tab \strong{Details} \cr
\code{dist1} \tab distribution \tab First distribution in convolution. \cr
\code{dist2} \tab distribution \tab Second distribution in convolution. \cr
\code{add} \tab logical \tab Add or subtract distributions. \cr
\code{type} \tab logical \tab Type of new distribution, automated if NULL. \cr
}
}

\seealso{
\code{\link{listWrappers}}
}
