% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_mean.R
\name{set_mean}
\alias{set_mean}
\title{Obtain mean values and reference categories of variables in a data.frame}
\usage{
set_mean(input, vary_by = NULL)
}
\arguments{
\item{input}{A \code{data.frame} object}

\item{vary_by}{A character string with the name of a variable over which the output dataframe should vary.}
}
\value{
A \code{data.frame} object with one row
}
\description{
This function purely exists for the \code{set_mean} argument of
\code{\link{plot_moments}}. It takes a data.frame and obtains the mean values
(numeric variables) and reference categories (categorical covariates).
}
\examples{

library("betareg")

# Get some data
beta_dat <- model_fam_data(fam_name = "betareg")

# Estimate model
betamod <- betareg(betareg ~ ., data = beta_dat)

# Obtain explanatory variables and set to mean
set_mean(model_data(betamod))
set_mean(model_data(betamod), vary_by = "binomial1")
}
