% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package_contents.R
\name{setup_model}
\alias{setup_model}
\alias{make_family}
\title{Setup Model and Formula}
\usage{
setup_model(
  model_name,
  synced_folder,
  clear_model = TRUE,
  formula = y ~ x1 + x2,
  family = binomial(),
  all_site_names = NULL,
  link = NULL,
  max_iterations = 100,
  tolerance = 1e-09
)

make_family(family, link = NULL)
}
\arguments{
\item{model_name}{name of your model}

\item{synced_folder}{synced folder to do computation}

\item{clear_model}{Should the model be cleared (all files deleted
model with same name) before creating new model}

\item{formula}{model formula to fit, with tilde syntax}

\item{family}{generalized linear model family, see \code{\link{family}}}

\item{all_site_names}{all the site names to fit this model}

\item{link}{link function to use with family}

\item{max_iterations}{maximum number of iterations to run}

\item{tolerance}{tolerance for convergence}
}
\value{
A character path to a formula/model file
}
\description{
Setup Model and Formula
}
\examples{
tdir = tempfile()
dir.create(tdir)
model_name = "logistic_example"
form_file = setup_model(model_name = model_name,
synced_folder = tdir,
formula =  y ~ x1 + x2, family =  binomial())

}
