% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Exponential.R
\name{Exponential}
\alias{Exponential}
\title{Create a Exponential distribution}
\usage{
Exponential(rate = 1)
}
\arguments{
\item{rate}{The rate parameter. Can be any positive number. Defaults
to \code{1}.}
}
\value{
A \code{Exponential} object.
}
\description{
Create a Exponential distribution
}
\examples{

set.seed(27)

X <- Exponential(5)
X

random(X, 10)

pdf(X, 2)
log_pdf(X, 2)

cdf(X, 4)
quantile(X, 0.7)

cdf(X, quantile(X, 0.7))
quantile(X, cdf(X, 7))
}
\seealso{
Other continuous distributions: \code{\link{Beta}},
  \code{\link{Cauchy}}, \code{\link{ChiSquare}},
  \code{\link{FisherF}}, \code{\link{Gamma}},
  \code{\link{LogNormal}}, \code{\link{Logistic}},
  \code{\link{Normal}}, \code{\link{StudentsT}},
  \code{\link{Tukey}}, \code{\link{Uniform}},
  \code{\link{Weibull}}
}
\concept{continuous distributions}
