% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bernoulli.R
\name{random.Bernoulli}
\alias{random.Bernoulli}
\title{Draw a random sample from a Bernoulli distribution}
\usage{
\method{random}{Bernoulli}(d, n = 1L, ...)
}
\arguments{
\item{d}{A \code{Bernoulli} object created by a call to \code{\link[=Bernoulli]{Bernoulli()}}.}

\item{n}{The number of samples to draw. Defaults to \code{1L}.}

\item{...}{Unused. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}
}
\value{
An integer vector of zeros and ones of length \code{n}.
}
\description{
Draw a random sample from a Bernoulli distribution
}
\examples{

set.seed(27)

X <- Bernoulli(0.7)
X

random(X, 10)
pdf(X, 1)
log_pdf(X, 1)
cdf(X, 0)
quantile(X, 0.7)

cdf(X, quantile(X, 0.7))
quantile(X, cdf(X, 0.7))
}
