% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gumbel.R
\name{pdf.Gumbel}
\alias{pdf.Gumbel}
\alias{log_pdf.Gumbel}
\title{Evaluate the probability mass function of a Gumbel distribution}
\usage{
\method{pdf}{Gumbel}(d, x, drop = TRUE, ...)

\method{log_pdf}{Gumbel}(d, x, drop = TRUE, ...)
}
\arguments{
\item{d}{A \code{Gumbel} object created by a call to \code{\link[=Gumbel]{Gumbel()}}.}

\item{x}{A vector of elements whose probabilities you would like to
determine given the distribution \code{d}.}

\item{drop}{logical. Should the result be simplified to a vector if possible?}

\item{...}{Arguments to be passed to \code{\link[revdbayes]{dgev}}.
Unevaluated arguments will generate a warning to catch mispellings or other
possible errors.}
}
\value{
In case of a single distribution object, either a numeric
vector of length \code{probs} (if \code{drop = TRUE}, default) or a \code{matrix} with
\code{length(x)} columns (if \code{drop = FALSE}). In case of a vectorized distribution
object, a matrix with \code{length(x)} columns containing all possible combinations.
}
\description{
Evaluate the probability mass function of a Gumbel distribution
}
\examples{

set.seed(27)

X <- Gumbel(1, 2)
X

random(X, 10)

pdf(X, 0.7)
log_pdf(X, 0.7)

cdf(X, 0.7)
quantile(X, 0.7)

cdf(X, quantile(X, 0.7))
quantile(X, cdf(X, 0.7))
}
