% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connection.R, R/dbExistsTable.R,
%   R/dbListTables-Fields.R, R/dbQueries-Results.R, R/dbMisc.R, R/quote.R
\docType{class}
\name{mock-db-methods}
\alias{mock-db-methods}
\alias{DBIMockConnection-class}
\alias{dbDisconnect,DBIMockConnection-method}
\alias{dbExistsTable,DBIMockConnection,character-method}
\alias{dbExistsTable,DBIMockConnection,Id-method}
\alias{dbListTables,DBIMockConnection-method}
\alias{dbListFields,DBIMockConnection,character-method}
\alias{dbListFields,DBIMockConnection,Id-method}
\alias{dbListFields,DBIMockConnection,ANY-method}
\alias{DBIMockResult-class}
\alias{dbSendQuery,DBIMockConnection,character-method}
\alias{dbFetch,DBIMockResult-method}
\alias{fetch,DBIMockResult,ANY-method}
\alias{fetch,DBIMockResult-method}
\alias{fetch,DBIMockResult,missing-method}
\alias{dbClearResult,DBIMockResult-method}
\alias{dbHasCompleted,DBIMockResult-method}
\alias{dbGetQuery,DBIMockRPostgreSQLConnection,character-method}
\alias{dbGetInfo,DBIMockConnection-method}
\alias{dbWriteTable,DBIMockConnection,character,data.frame-method}
\alias{dbRemoveTable,DBIMockConnection,character-method}
\alias{dbColumnInfo,DBIMockResult-method}
\alias{dbGetInfo,DBIMockResult-method}
\alias{dbQuoteIdentifier,DBIMockRPostgresConnection,character-method}
\alias{dbQuoteIdentifier,DBIMockRPostgresConnection,SQL-method}
\title{Methods for interacting with DB mocks instead of an actual database}
\usage{
\S4method{dbDisconnect}{DBIMockConnection}(conn, ...)

\S4method{dbExistsTable}{DBIMockConnection,character}(conn, name, ...)

\S4method{dbExistsTable}{DBIMockConnection,Id}(conn, name, ...)

\S4method{dbListTables}{DBIMockConnection}(conn, ...)

\S4method{dbListFields}{DBIMockConnection,character}(conn, name, ...)

\S4method{dbListFields}{DBIMockConnection,Id}(conn, name, ...)

\S4method{dbListFields}{DBIMockConnection,ANY}(conn, name, ...)

\S4method{dbSendQuery}{DBIMockConnection,character}(conn, statement, ...)

\S4method{dbFetch}{DBIMockResult}(res, n = -1, ...)

\S4method{fetch}{DBIMockResult,ANY}(res, n = -1, ...)

\S4method{fetch}{DBIMockResult,missing}(res, n = -1, ...)

\S4method{dbClearResult}{DBIMockResult}(res, n, ...)

\S4method{dbHasCompleted}{DBIMockResult}(res, ...)

\S4method{dbGetQuery}{DBIMockRPostgreSQLConnection,character}(conn, statement, ...)

\S4method{dbGetInfo}{DBIMockConnection}(dbObj, ...)

\S4method{dbWriteTable}{DBIMockConnection,character,data.frame}(conn, name, value, ...)

\S4method{dbRemoveTable}{DBIMockConnection,character}(conn, name, ...)

\S4method{dbColumnInfo}{DBIMockResult}(res, ...)

\S4method{dbGetInfo}{DBIMockResult}(dbObj, ...)

\S4method{dbQuoteIdentifier}{DBIMockRPostgresConnection,character}(conn, x, ...)

\S4method{dbQuoteIdentifier}{DBIMockRPostgresConnection,SQL}(conn, x, ...)
}
\arguments{
\item{conn}{a database connection (for dispatch with these methods, it should
be of class \code{DBIMockConnection})}

\item{...}{arguments passed on inside of the methods}

\item{name}{name of the table (for \code{\link{dbListFields}}, \code{\link{dbWriteTable}},
\code{\link{dbRemoveTable}})}

\item{statement}{an SQL statement to execute}

\item{res}{a result object (for dispatch with these methods, it should be of
class \code{DBIMockResult})}

\item{n}{number of results to fetch (ignored)}

\item{dbObj}{a database object (a connection, result, etc.) for use in
\code{\link{dbGetInfo}}}

\item{value}{a value (generally a \code{data.frame}) for use in \code{\link{dbWriteTable}}}

\item{x}{a name to quote (for \code{\link{dbQuoteIdentifier}})}
}
\description{
Various methods (\code{dbSendQuery}, \code{dbFetchQuery}) that are mocks of the
\href{https://CRAN.R-project.org/package=DBI}{DBI} methods of the same name.
Instead of actually interacting with a database, they read in mock responses
and the code proceeds after that. These aren't used directly, but are part of
how {dittodb} works.
}
