% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redact.R
\name{redact_columns}
\alias{redact_columns}
\title{Redact columns from a dataframe with the default redactors}
\usage{
redact_columns(data, columns, ignore.case = TRUE, ...)
}
\arguments{
\item{data}{a dataframe to redact}

\item{columns}{character, the columns to redact}

\item{ignore.case}{should case be ignored? (default: \code{TRUE})}

\item{...}{additional options to pass on to \code{grep()} when matching the column
names}
}
\value{
data, with the columns specified in \code{columns} duly redacted
}
\description{
This function redacts the columns specified in \code{columns} in the data given in
\code{data} using {dittodb}'s standard redactors.
}
\details{
The column names given in the \code{columns} argument are treated as regular
expressions, however they always have \code{^} and \code{$} added to the beginning and
end of the strings. So if you would like to match any column that starts with
the string \code{sensitive} (e.g. \code{sensitive_name}, \code{sensitive_date}) you could
use \verb{"sensitive.*} and this would catch all of those columns (though it would
not catch a column called \code{most_sensitive_name}).

The standard redactors replace all values in the column with the following
values based on the columns type:
\itemize{
\item integer -- \code{9L}
\item numeric -- \code{9}
\item character -- \code{"[redacted]"}
\item \code{POSIXct} (date times) -- \code{as.POSIXct("1988-10-11T17:00:00", tz = tzone)}
}
}
\examples{
if (check_for_pkg("nycflights13", message)) {
  small_flights <- head(nycflights13::flights)

  # with no columns specified, redacting does nothing
  redact_columns(small_flights, columns = NULL)

  # integer
  redact_columns(small_flights, columns = c("arr_time"))

  # numeric
  redact_columns(small_flights, columns = c("arr_delay"))

  # characters
  redact_columns(small_flights, columns = c("origin", "dest"))

  # datetiems
  redact_columns(small_flights, columns = c("time_hour"))
}
}
