% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{set_dittodb_debug_level}
\alias{set_dittodb_debug_level}
\title{Set \code{dittodb}'s debug level}
\usage{
set_dittodb_debug_level(level)
}
\arguments{
\item{level}{a numeric, the level to set to (e.g. 1)}
}
\value{
the level, invisibly
}
\description{
It can be helpful to see what's going on by increasing \code{dittodb}'s verbosity
which will show what's going on under the hood (e.g. what queries are being
requested, from where). This sets the option \code{dittodb.debug} to the value
given in the \code{level} argument. The option can be set directly with
\code{options(dittodb.debug = n)} as well.
}
\details{
The \code{level} argument is a numeric, where 0 is the default and (relatively)
silent. The higher the level, the more verbose \code{dittodb} will be.

Currently, \code{dittodb} only has one level of debugging (any value 1 or
greater), but more might be used in the future.
}
\examples{
set_dittodb_debug_level(1)
set_dittodb_debug_level(0)
}
