% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shannon.R
\name{ds_shannon}
\alias{ds_shannon}
\alias{shannon}
\title{Compute Shannon Index}
\usage{
ds_shannon(.data, .cols, .name)

shannon(..., .data = dplyr::cur_data_all())
}
\arguments{
\item{.data}{\link[tibble:tibble-package]{tibble}}

\item{.cols}{\href{https://tidyselect.r-lib.org/reference/language.html}{\code{tidy-select}}
Columns to compute the measure with.}

\item{.name}{name for column with Shannon index. Leave missing to return a vector.}

\item{...}{arguments to forward to ds_shannon from shannon}
}
\value{
a \link[tibble:tibble-package]{tibble} or numeric vector if .name missing
}
\description{
Compute Shannon Index
}
\examples{
data("de_county")
ds_shannon(de_county, starts_with('pop_'))
ds_shannon(de_county, starts_with('pop_'), 'shannon')
}
\concept{div}
