% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predefined_tests.R
\name{predefined_tests}
\alias{predefined_tests}
\alias{exact_match}
\alias{range_match}
\alias{range_match_legacy}
\alias{prob_link}
\title{Predefined logical tests in \bold{\code{diyar}}}
\usage{
exact_match(x, y)

range_match(x, y, range = 10)

range_match_legacy(x, y)

prob_link(
  x,
  y,
  cmp_threshold,
  m_probability,
  score_threshold,
  return_weights,
  probabilistic,
  cmp_func
)
}
\arguments{
\item{x}{Value of an attribute(s) to be compare against.}

\item{y}{Value of an attribute(s) to be compare by.}

\item{range}{Difference between \code{y} and \code{x}.}

\item{cmp_threshold}{Matching set of weight thresholds for each result of \code{cmp_func}. See \code{\link{links_wf_probabilistic}}.}

\item{m_probability}{Matching set of m-probabilities. The probability that a match from \code{cmp_func} is a true match. See \code{\link{links_wf_probabilistic}}.}

\item{score_threshold}{Score threshold determining matched or linked records. See \code{\link{links_wf_probabilistic}}.}

\item{return_weights}{If \code{TRUE}, returns the match-weights and score-thresholds for record pairs. See \code{\link{links_wf_probabilistic}}.}

\item{probabilistic}{If \code{TRUE}, matches determined through a score derived base on Fellegi-Sunter model for probabilistic linkage. See \code{\link{links_wf_probabilistic}}.}

\item{cmp_func}{Logical tests such as string comparators. See \code{\link{links_wf_probabilistic}}.}
}
\description{
A collection of predefined logical tests used with \bold{\code{\link{sub_criteria}}} objects.
}
\details{
\bold{\code{exact_match()}} - test that  \code{x == y}

\bold{\code{range_match()}} - test that \code{x} \eqn{\le} \code{y} \eqn{\le} \code{(x + range)}

\bold{\code{range_match_legacy()}} - test that \code{overlap(as.number_line(x@gid), y)} is \code{TRUE}.

\bold{\code{prob_link()}} - Test that a record sets \code{x} and \code{y} are from the same entity based on calculated weights and probability scores.
}
\examples{
`exact_match`
exact_match(x = 1, y = 1)
exact_match(x = 1, y = 2)

`range_match`
range_match(x = 10, y = 16, range = 6)
range_match(x = 16, y = 10, range = 6)

`range_match_legacy`
x_nl <- number_line(10, 16, gid = 10)
y_nl1 <- number_line(16, 10)
y_nl2 <- number_line(16, 10)

range_match_legacy(x = x_nl, y = y_nl1)
range_match_legacy(x = x_nl, y = y_nl2)


}
